<?php

use Spatie\Permission\Models\Role;

if (! function_exists('get_pages')) {
	function get_pages()
	{
		$pages = \App\Models\Page::orderBy('id', 'asc')->get();
		return $pages;
	}
}


if ( ! function_exists('get_faq_types')) {
	function get_faq_types()
	{
		return \App\Models\FaqType::orderBy('id', 'asc')->get();
	}
}

if (! function_exists('get_faqs')) {
	function get_faqs()
	{
		return \App\Models\Faq::where('status', 1)->orderBy('id', 'desc')->get();
	}
}

if ( ! function_exists('get_option')){
	function get_option($name)
	{
        $setting = DB::table('settings')->where('name', $name)->get();
        if ( ! $setting->isEmpty() ) {
            return $setting[0]->value;
        }
        return "";
	}
}


if ( ! function_exists('create_option')){
	function create_option($table,$value,$display,$selected="",$where=NULL){
		$options = "";

		$last_name = 'last_name';
		$query = DB::table($table)->select('*')
							->where('user_id', Auth::user()->id)
							->orderBy('id', 'desc')->get();
		foreach($query as $d){
			if( $selected!="" && $selected == $d->$value ){
				$options.="<option value='".$d->$value."' selected='true'>".ucwords($d->$display) . ' ' . ucwords($d->$last_name)."</option>";
			}else{
				$options.="<option value='".$d->$value."'>".ucwords($d->$display) . ' ' . ucwords($d->$last_name) ."</option>";
			}
		}

		echo $options;
	}
}

if (! function_exists('get_auth')) {
	function get_auth()
	{
		return Auth::user()->roles()->first()->name;
	}
}


if (! function_exists('get_dark_mode')) {
	function get_dark_mode()
	{
		return Auth::user()->dark_mode;
	}
}

if (! function_exists('get_visitors')) {
	function get_visitors()
	{
		return \App\Models\Visitor::orderBy('id', 'desc')->get();
	}
}

if (! function_exists('get_contacts')) {
	function get_contacts()
	{
		return \App\Models\Contact::orderBy('id', 'desc')->get();
	}
}


if (! function_exists('get_users')) {
	function get_users()
	{
		return \App\Models\User::where('users.id', '!=', 1)->orderBy('id', 'desc')->get();
	}
}

if (! function_exists('get_roles')) {
	function get_roles()
	{
		if (get_auth() == 'super admin') {
			return Role::orderBy('id', 'asc')->get();
		}else {
			return Role::where('id', '!=', 1)->where('id', '!=', 2)
						->orderBy('id', 'asc')->get();
		}
	}
}


// Get Unit
if (! function_exists('get_units')) {
	function get_units()
	{
		return \App\Models\Unit::orderBy('id', 'asc')->get();
	}
}

// Category
if (! function_exists('get_categories')) {
	function get_categories()
	{
		return \App\Models\Category::where('status', 1)->orderBy('id', 'desc')->get();
	}
}

if (! function_exists('get_parent_categories')) {
	function get_parent_categories()
	{
		if (get_auth() != 'super admin') {
			$categories = \App\Models\Category::whereNull('parent_category')
									->orderBy('id', 'desc')->get();
		}else {
			$category = '';
		}

		return $categories;
	}
}

if (! function_exists('get_first_category')) {
	function get_first_category($category='')
	{
		return \App\Models\Category::find($category);
	}
}

if (! function_exists('get_sub_categories')) {
	function get_sub_categories($category='')
	{
		return \App\Models\Category::where('parent_category', $category)->get();
	}
}

if (! function_exists('get_subcategories')) {
	function get_subcategories($value)
	{
		$sub_category = [];
		$childCategory = [];
		$categories = \App\Models\Category::where('parent_category', $value)->get();
		foreach ($categories as $category) {
			$sub_category[] = [
				'id' => $category->id,
				'slug' => $category->slug,
				'title' => $category->title,
				'image' => $category->image,
				'childCategory' => get_childcategories($category->id)
			];
		}

		return $sub_category;
	}
}

if (! function_exists('get_childcategories')) {
	function get_childcategories($value)
	{
		$sub_category = [];
		$categories = \App\Models\Category::where('parent_category', $value)->get();
		foreach ($categories as $category) {
			$sub_category[] = [
				'id' => $category->id,
				'slug' => $category->slug,
				'title' => $category->title,
				'image' => $category->image
			];
		}

		return $sub_category;
	}
}


// Filter By Brand
if (! function_exists('get_brand_lists')) {
	function get_brand_lists($brand)
	{
		return \App\Models\Brand::find($brand);
	}
}

if (! function_exists('get_category_lists')) {
	function get_category_lists($brand)
	{
		return \App\Models\Category::find($brand);
	}
}


// Seller & Brands
if (! function_exists('get_brands')) {
	function get_brands()
	{
		return \App\Models\Brand::where('status', 1)
								->orderBy('id', 'desc')->get();
	}
}

if (! function_exists('get_testimonials')) {
	function get_testimonials()
	{
		$testimonial = \App\Models\Testimonial::where('status', 1)
											->orderBy('id', 'desc')
                                            ->get();

		return $testimonial;
	}
}

// Social Media
if (! function_exists('get_social_medias')) {
	function get_social_medias()
	{
		$testimonial = \App\Models\SocialMedia::where('status', 1)
											->orderBy('id', 'desc')
                                            ->get();

		return $testimonial;
	}
}


// Notification, Admin
if (! function_exists('get_admins')) {
	function get_admins()
	{
		return \App\Models\User::select('*', 'users.id as id')
                    ->join('model_has_roles', 'model_has_roles.model_id', '=', 'users.id')
                    ->where('model_has_roles.role_id', 1)
                    ->orWhere('model_has_roles.role_id', 2)
                    ->orderBy('users.id', 'desc')->get();
	}
}

if (! function_exists('get_api_notifications')) {
	function get_api_notifications($notifications)
	{
		$notificationLists = [];

		foreach ($notifications as $key => $notification) {
			$notificationLists[] = [
				'slug' => $notification->slug,
				'title' => $notification->title,
				'date' => $notification->created_at->format('d M, Y H:i'),
				'status' => $notification->status,
			];
		}

		return $notificationLists;
	}
}


// Application
if (! function_exists('get_joblists')) {
	function get_joblists()
	{
		$jobs = \App\Models\JobVacancy::where('status', 1)->orderBy('id', 'desc')->get();
		return $jobs;
	}
}



if (! function_exists('get_products')) {
	function get_products()
	{
		$products = \App\Models\Product::orderBy('id', 'desc')->get();
		return $products;
	}
}

if (! function_exists('get_products_by_category')) {
	function get_products_by_category($category)
	{
        $products = [];
        $category = \App\Models\Category::where('slug', $category)->first();
        if ($category) {
            $products = \App\Models\Product::where('category_id', $category->id)
                                        ->orderBy('id', 'desc')
                                        ->get();
        }
		return $products;
	}
}

if (! function_exists('get_teams')) {
	function get_teams()
	{
		return \App\Models\User::select('*', 'users.id as id')
                    ->join('model_has_roles', 'model_has_roles.model_id', '=', 'users.id')
					->where('model_has_roles.role_id', 4)
					->orWhere('model_has_roles.role_id', 5)
					->orWhere('model_has_roles.role_id', 6)
                    ->orWhere('model_has_roles.role_id', 7)
                    ->orderBy('users.id', 'desc')->get();
	}
}

if (! function_exists('get_endusers')) {
	function get_endusers()
	{
		return \App\Models\User::select('*', 'users.id as id')
                    ->join('model_has_roles', 'model_has_roles.model_id', '=', 'users.id')
                    ->where('model_has_roles.role_id', 3)
                    ->orderBy('users.id', 'desc')->get();
	}
}

if (! function_exists('get_check_offer')) {
	function get_check_offer($product, $offer)
	{
		$shopId = \App\Models\OfferProduct::where('product_id', $product->id)->where('offer_id', $offer->id)->first();
		if ($shopId) {
			return true;
		}else {
			return false;
		}
	}
}

if (! function_exists('get_plugins')) {
	function get_plugins($type)
	{
		return \App\Models\Plugin::where('type', $type)
							->where('status', 1)
							->orderBy('id', 'desc')->get();
	}
}


// Blog
if (! function_exists('get_blog_categories')) {
	function get_blog_categories()
	{
		$categories = \App\Models\BlogCategory::where('status', 1)->orderBy('id', 'asc')->get();
		return $categories;
	}
}


if (! function_exists('get_recent_blog')) {
	function get_recent_blog()
	{
		$categories = \App\Models\Blog::where('status', 1)->orderBy('id', 'desc')->get();
		return $categories;
	}
}

if (! function_exists('get_home_categories')) {
	function get_home_categories()
	{
		$categories = \App\Models\Category::where('display_home', 1)
							->where('status', 1)
							->orderBy('id', 'desc')->get();

		return $categories;
	}
}

// Related Product
if (! function_exists('get_related_products')) {
	function get_related_products($product)
	{
		$products = \App\Models\Product::inRandomOrder()->where('id', '!=', $product->id)
										->where('status', 1)
										->orderBy('id', 'desc')->get();

		return $products;
	}
}

if (! function_exists('get_shops')) {
	function get_shops()
	{
		return \App\Models\Shop::where('status', 1)
						->orderBy('id', 'asc')->get();
	}
}

// ABout Page
if (! function_exists('get_about_page')) {
	function get_about_page()
	{
		$page = \App\Models\AboutPage::orderBy('id', 'asc')->get();
		return $page->first();
	}
}

// Location
if (! function_exists('get_locations')) {
	function get_locations()
	{
		$methods = \App\Models\Location::where('status', 1)
									->orderBy('title','asc')
                                    ->get();

		return $methods;
	}
}

// Location
if (! function_exists('get_certificates')) {
	function get_certificates()
	{
		$methods = \App\Models\Certificate::where('status', 1)
									->orderBy('id', 'desc')
                                    ->get();

		return $methods;
	}
}

if (! function_exists('get_qualities')) {
	function get_qualities()
	{
		$methods = \App\Models\Quality::where('status', 1)
									->orderBy('id','asc')->get();

		return $methods;
	}
}

//Image Upload
if (! function_exists('get_upload_images')) {
    function get_upload_images($image, $location)
    {
        $fileName = null;
        if ($image->getClientOriginalExtension() == 'webp') {
            $fileName = \Illuminate\Support\Str::uuid() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('frontend/images/' . $location . '/'), $fileName);
        } else {
			// dd($image);
            $webp = Webp::make($image);
            $fileName = \Illuminate\Support\Str::uuid() . '.webp';
            $webp->save(public_path('frontend/images/' . $location . '/' . $fileName));
        }

        return $fileName;
    }
}

if (! function_exists('get_remove_images')) {
    function get_remove_images($image, $location)
    {
        if ($image) {
            $path = public_path('frontend/images/' . $location .'/') . $image;

            if (file_exists($path)) {
                unlink($path);
            }
        }
    }
}

if (! function_exists('get_change_tags')) {
	function get_change_tags($tags)
	{
		$tags = explode(",", $tags);
		$tagList = "";
		foreach ($tags as $key => $tag) {
            $something = count($tags) > ++$key ? ", " : '';
			$tagList .= ucfirst(trans($tag)) . $something;
		}

		return $tagList;
	}
}

// Page
if (! function_exists('get_page')) {
	function get_page($slug)
	{
		$page = \App\Models\Page::where('slug', $slug)->first();

		if ($page) {
			return $page;
		} else {
			return false;
		}
	}
}

// Page Seo
if (! function_exists('get_seo_page')) {
	function get_seo_page($slug)
	{
		$page = \App\Models\PageSeo::where('slug', $slug)->first();

		if ($page) {
			return $page;
		} else {
			return false;
		}
	}
}

// Related Offers
if (! function_exists('get_suppliers')) {
	function get_suppliers()
	{
		$offers = \App\Models\Supplier::orderBy('id', 'desc')->get();
		return $offers;
	}
}

if (! function_exists('get_offer_requests')) {
	function get_offer_requests()
	{
		$requests = \App\Models\OfferRequest::orderBy('id', 'desc')->get();
		return $requests;
	}
}

if (! function_exists('get_product_requests')) {
	function get_product_requests()
	{
		$requests = \App\Models\ProductRequest::orderBy('id', 'desc')->get();
		return $requests;
	}
}

if (! function_exists('get_related_offers')) {
	function get_related_offers($offer)
	{
		$products = \App\Models\Offer::inRandomOrder()->where('id', '!=', $offer->id)
										->where('status', 1)
										->orderBy('id', 'desc')->get();

		return $products;
	}
}

// Subscriber
if (! function_exists('get_subscribers')) {
	function get_subscribers()
	{
		$subscribers = \App\Models\Subscriber::orderBy('id', 'desc')->get();
		return $subscribers;
	}
}

// Candidate
if (! function_exists('get_candidates')) {
	function get_candidates()
	{
		$candidates = \App\Models\Candidate::orderBy('id', 'desc')->get();
		return $candidates;
	}
}

// Dealer Enquiry
if (! function_exists('get_dealer_enquiries')) {
	function get_dealer_enquiries()
	{
		$dealers = \App\Models\DealerEnquiry::orderBy('id', 'desc')->get();
		return $dealers;
	}
}

// Customer Enquiry
if (! function_exists('get_customer_enquiries')) {
	function get_customer_enquiries()
	{
		$dealers = \App\Models\CustomerEnquiry::orderBy('id', 'desc')->get();
		return $dealers;
	}
}

// Contact Form
if (! function_exists('get_contact_forms')) {
	function get_contact_forms()
	{
		$contacts = \App\Models\ContactForm::orderBy('id', 'desc')->get();
		return $contacts;
	}
}

// Slider
if (! function_exists('get_banners')) {
    function get_banners()
    {
        $banners = \App\Models\Slider::where('status', 1)
                                        ->orderBy('id', 'desc')
                                        ->get();
        return $banners;
    }
}

// Service
if (! function_exists('get_services')) {
    function get_services()
    {
        $services = \App\Models\Service::where('status', 1)
                                        ->orderBy('id', 'desc')
                                        ->get();
        return $services;
    }
}

// Api

if (! function_exists('get_product_categories')) {
    function get_product_categories()
    {
        $categories = \App\Models\Category::whereNull('parent_category')->where('status', 1)->orderBy('title', 'asc')->get();
        return $categories;
    }
}

if (! function_exists('get_api_category')) {
    function get_api_category($item)
    {
        $categories = [];

        if ($item) {
            $categories = [
                'id' => $item->id,
                'slug' => $item->slug,
                'title' => $item->title,
                'image' => $item->image ? $item->imageUrl : null,
            ];
        }

        return $categories;
    }
}

if (! function_exists('get_api_sub_categories')) {
    function get_api_sub_categories($category, $currentCategory)
    {
        $categories = [];

        if ($category) {
            $categoryList = \App\Models\Category::where('status', 1)->where('parent_category', $category->id)
                                        ->orderBy('title', 'asc')->get();

            if ($categoryList) {
                foreach ($categoryList as $key => $item) {
			if ($item->status == 1) {
				if ($currentCategory) {
					if ($currentCategory->id == $item->id) {
						$checked = true;
					} else {
						if ($currentCategory->id == $item->parent_category) {
							$checked = true;
						} else {
							$checked = false;
						}
					}
				} else {
					$checked = false;
				}

                    $categories[] = [
                        'id' => $item->id,
                        'slug' => $item->slug,
                        'title' => $item->title,
                        'checked' => $checked,
                        'image' => $item->image ? $item->imageUrl : null,
                        'childCategory' => get_api_sub_categories($item, $currentCategory)
                    ];
			}
                }
            }
        }

        return $categories;
    }
}

if (! function_exists('get_api_products')) {
    function get_api_products($products)
    {
        $productList = [];
        if ($products) {
            foreach ($products as $key => $product) {
                if (Auth::guest()) {
                    if ($product->discount_price) {
                        $retailerPrice = number_format($product->retailer_price, 2);
                    } else {
                        $retailerPrice = number_format($product->discount_price, 2);
                    }
                } else {
                    if ($product->discount_price != null) {
                        $retailerPrice = number_format($product->discount_price, 2);
                    } else {
                        $retailerPrice = number_format($product->UserRole_price(), 2);
                    }
                }
                $productList[] = [
                    'id' => $product->id,
                    'slug' => $product->slug,
                    'title' => $product->title,
                    'image' => $product->image ? $product->imageUrl : null,
                    'mrp_price' => number_format($product->mrp, 2),
                    'retailer_price' => $retailerPrice,
                    'category' => $product->category ? $product->category->title : '-',
                ];
            }
        }

        return $productList;
    }
}

if (! function_exists('get_api_frontend_brands')) {
    function get_api_frontend_brands($items) {
        $categories = [];

        if ($items) {
            foreach ($items as $key => $item) {
                $categories[]  = [
                    'slug' => $item->slug,
                    'id' => $item->id,
                    'title' => $item->title,
                    'checked' => false
                ];
            }
        }

        return $categories;
    }
}

if (! function_exists('get_api_frontend_products')) {
    function get_api_frontend_products($items) {
        $products = [];

        if ($items) {
            foreach ($items as $key => $item) {
                $products[]  = [
                    'slug' => $item->slug,
                    'title' => $item->title,
                    'category' => $item->category ? $item->category->title : '-',
                    'image' => $item->imageUrl,
                    'price' => $item->price,
                    'sale_price' => $item->sale_price,
                    'quantity' => $item->quantity
                ];
            }
        }

        return $products;
    }
}

if (! function_exists('get_api_check_specifications')) {
    function get_api_check_specifications($request, $specifications) {
        $items = [];

        if (isset($specifications)) {
            foreach ($specifications as $key => $item) {
                if ($item != null)  {
                    $items[] = [
                        "title" => $item,
                        "description" => $request['tab_content'][$key]
                    ];
                }
            }
        }

        return $items;
    }
}
