<?php

namespace App\Mail\Admin;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CareerMail extends Mailable
{
    use Queueable, SerializesModels;

    public $jobTitle;
    public $name;
    public $email;
    public $phone;
    public $dob;
    public $gender;
    public $paddress;
    public $taddress;
    public $education;
    public $experience;
    public $message;
    public $resume;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($jobTitle, $name, $email, $phone, $dob, $gender, $paddress, $taddress, $education, $experience, $message, $resume)
    {
        $this->jobTitle = $jobTitle;
        $this->name = $name;
        $this->email = $email;
        $this->phone = $phone;
        $this->dob = $dob;
        $this->gender = $gender;
        $this->paddress = $paddress;
        $this->taddress = $taddress;
        $this->education = $education;
        $this->experience = $experience;
        $this->message = $message;
        $this->resume = $resume;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.admin.career-mail')
                    ->subject('New Contact Enquiry Notification');
    }
}
