<?php

namespace App\Mail\User;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CareerMailFromDiabeticCareFood extends Mailable
{
    use Queueable, SerializesModels;

    public $jobTitle;
    public $name;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($jobTitle, $name)
    {
        $this->jobTitle = $jobTitle;
        $this->name = $name;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.user.career-mail')
                    ->subject('Thank You for Applying at ' . config('app.name'));
    }
}
