<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    public function parent()
    {
        return $this->belongsTo(Category::class, 'parent_category');
    }
    
    public function getImageUrlAttribute($value)
    {
        $imageUrl = null;

        if ( ! is_null($this->image))
        {
            $directory = '/frontend/images/categories/';
            $imagePath = public_path() . "{$directory}" . $this->image;
            if (file_exists($imagePath)) $imageUrl = asset("$directory" . $this->image);
        }

        return $imageUrl;
    }

    public function childs()
    {
    	return $this->hasMany(Category::class, 'parent_category');
    }

    public function products()
    {
        return $this->hasMany(Product::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getRouteKeyName()
    {
        return 'slug';
    }
}
