<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Testimonial extends Model
{
    use HasFactory;

    public function getImageUrlAttribute($value)
    {
        $imageUrl = null;

        if ( ! is_null($this->image))
        {
            $directory = '/frontend/images/testimonials/';
            $imagePath = public_path() . "{$directory}" . $this->image;
            if (file_exists($imagePath)) $imageUrl = asset("$directory" . $this->image);
        }

        return $imageUrl;
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getRouteKeyName()
    {
        return 'slug';
    }
}
