<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateComplainsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('complains', function (Blueprint $table) {
            $table->id();
            $table->string('slug')->unique();
            $table->string('name');
            $table->string('email')->nullable();
            $table->string('phone_number');
            $table->string('state');
            $table->string('city');
            $table->string('address');
            $table->string('street');
            $table->string('landmark')->nullable();
            $table->string('category')->nullable();
            $table->string('product_name');
            $table->string('complain_type');
            $table->string('warrenty')->nullable();
            $table->string('bill_card')->nullable();
            $table->string('date_of_purchase');
            $table->longText('remarks')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('complains');
    }
}
