<?php

namespace Database\Seeders;

use DB;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // resets the users table
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('permissions')->truncate();
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();
        $permissions = [
        	'role-list',
        	'role-create',
            'role-edit',
        	'role-delete',
            'category-list',
            'category-create',
            'category-edit',
            'category-delete',
            'product-list',
            'product-create',
            'product-edit',
            'product-delete',
            'page-list',
            'page-create',
            'page-edit',
            'page-delete',
            'job-list',
            'job-create',
            'job-edit',
            'job-delete',
            'candidate-list',
            'candidate-delete',
            'general-setting',
            'certificate-list',
            'certificate-edit',
            'certificate-create',
            'certificate-delete',
            'testimonial-list',
            'testimonial-create',
            'testimonial-edit',
            'testimonial-delete',
            'faq-list',
            'faq-edit',
            'faq-create',
            'faq-delete',
            'faq-type-list',
            'faq-type-edit',
            'faq-type-create',
            'faq-type-delete',
            'setting-general',
            'dealer-enquiry-list',
            'dealer-enquiry-delete',
            'customer-enquiry-list',
            'customer-enquiry-delete',
            'product-request-list',
            'product-request-delete',
            'plugin-list',
            'plugin-create',
            'plugin-edit',
            'plugin-delete',
            'location-list',
            'location-create',
            'location-edit',
            'location-delete',
            'subscriber-list',
            'subscriber-delete',
            'contact-us-list',
            'contact-us-show',
            'contact-us-delete',
            'blog-list',
            'blog-create',
            'blog-edit',
            'blog-delete',
            'blog-category-list',
            'blog-category-create',
            'blog-category-edit',
            'blog-category-delete',
            'user-list',
            'user-create',
            'user-edit',
            'user-delete',
            'supplier-list',
            'supplier-create',
            'supplier-edit',
            'supplier-delete',
            'event-list',
            'event-create',
            'event-edit',
            'event-delete',
            'gallery-list',
            'gallery-create',
            'gallery-edit',
            'gallery-delete',
            'video-list',
            'video-create',
            'video-edit',
            'video-delete',
            'seo-list',
            'seo-create',
            'seo-edit',
            'seo-delete',
            'admin-backup',
            'admin-setting',
            'admin-notification',
            'admin-mail',
            'admin-utilities',
            'slider-list',
            'slider-create',
            'slider-edit',
            'slider-delete',
            'seo-manage'
        ];
        foreach ($permissions as $permission) {
        	Permission::create(['name'=>$permission]);
        }
    }
}
