"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _utils = require("@material-ui/core/utils");

var _styles = require("@material-ui/core/styles");

var _TimelineContext = _interopRequireDefault(require("./TimelineContext"));

var styles = function styles() {
  return {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      flexDirection: 'column',
      padding: '6px 16px',
      flexGrow: 1
    },

    /* Styles applied to the root element if `align="left"`. */
    alignLeft: {},

    /* Styles applied to the root element if `align="right"`. */
    alignRight: {},

    /* Styles applied to the root element if `align="alternate"`. */
    alignAlternate: {}
  };
};

exports.styles = styles;
var Timeline = /*#__PURE__*/React.forwardRef(function Timeline(props, ref) {
  var _props$align = props.align,
      align = _props$align === void 0 ? 'left' : _props$align,
      classes = props.classes,
      className = props.className,
      other = (0, _objectWithoutProperties2.default)(props, ["align", "classes", "className"]);
  return /*#__PURE__*/React.createElement(_TimelineContext.default.Provider, {
    value: {
      align: align
    }
  }, /*#__PURE__*/React.createElement("ul", (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, classes["align".concat((0, _utils.capitalize)(align))], className),
    ref: ref
  }, other)));
});
process.env.NODE_ENV !== "production" ? Timeline.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The position where the timeline's content should appear.
   */
  align: _propTypes.default.oneOf(['alternate', 'left', 'right']),

  /**
   * The content of the component.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string
} : void 0;

var _default = (0, _styles.withStyles)(styles, {
  name: 'MuiTimeline'
})(Timeline);

exports.default = _default;