import React from "react";
import { Col, Row } from "react-bootstrap";
import MainCategory from "./components/MainCategory";
import ProductList from "./ProductList";
import MobileFilter from "./components/MobileFilter";
import FilterBrand from "./components/FilterBrand";
import FilterList from "./FilterList";

const FilterBy = ({
    loading,
    categories,
    products,
    handleChange,
    selectedCategories,
    totalProducts,
    category,
    sort,
    setSort,
    currentPage,
    perPages,
    getData,
    show,
    handleClose,
    handleShow,
    brands,
    handleChangeBrand,
    checkedBrands,
}) => {
    return (
        <>
            <Row className="g-4">
                <FilterList
                    handleShow={handleShow}
                    sort={sort}
                    setSort={setSort}
                />
                <Col
                    lg={3}
                    className="desktop__filter hidden"
                    id="filter-sidebar"
                >
                    <div className="service-sidebar">
                        <FilterBrand
                            loading={loading}
                            brands={brands}
                            handleChange={handleChangeBrand}
                        />
                        <MainCategory
                            loading={loading}
                            categories={categories}
                            handleChange={handleChange}
                        />
                    </div>
                </Col>

                <Col lg={12} id="products-col">
                    <div className="th-sort-bar">
                        <div className="store__container">
                            <div className="col-md desktop__filter">
                                {totalProducts} products found{" "}
                                {category.title && <>on {category.title}</>}
                            </div>
                        </div>
                    </div>
                    <div>
                        <div className="mobile__filter mb-3">
                            {totalProducts} products found{" "}
                            {category.title && <>on {category.title}</>}
                        </div>
                        <ul className="category__list">
                            {checkedBrands.length > 0 &&
                                checkedBrands.map((item, index) => (
                                    <li key={index}>
                                        <div className="category__item">
                                            {item.title}
                                            <label
                                                onClick={() =>
                                                    handleChangeBrand(
                                                        item.id,
                                                        item.type
                                                    )
                                                }
                                                className="filter-summary-removeFilter"
                                            >
                                                <span className="filter-summary-removeIcon sprites-remove">
                                                    <i className="fal fa-times"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </li>
                                ))}
                            {selectedCategories.length > 0 &&
                                selectedCategories.map((item, index) => (
                                    <li key={index}>
                                        <div className="category__item">
                                            {item.title}
                                            <label
                                                onClick={() =>
                                                    handleChange(
                                                        item.id,
                                                        item.type
                                                    )
                                                }
                                                className="filter-summary-removeFilter"
                                            >
                                                <span className="filter-summary-removeIcon sprites-remove">
                                                    <i className="fal fa-times"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </li>
                                ))}
                        </ul>
                    </div>
                    <ProductList
                        loading={loading}
                        products={products}
                        perPages={perPages}
                        currentPage={currentPage}
                        totalProducts={totalProducts}
                        getData={getData}
                    />
                </Col>
            </Row>
            <MobileFilter
                show={show}
                loading={loading}
                handleClose={handleClose}
                categories={categories}
                handleChange={handleChange}
                brands={brands}
                handleChangeBrand={handleChangeBrand}
            />
        </>
    );
};

export default FilterBy;
