import React, { useEffect, useState } from "react";
import { Container } from "react-bootstrap";

import axios from "axios";
import "owl.carousel/dist/assets/owl.carousel.css";
import "owl.carousel/dist/assets/owl.theme.default.css";
import ReactOwlCarousel from "react-owl-carousel";

const AvailableShop = () => {
    const [loading, setLoading] = useState(false);
    const [shops, setShops] = useState([]);

    const loadData = async () => {
        setLoading(true);
        try {
            const response = await axios.get("/api/shops");
            setShops(response.data.shops);
        } catch (error) {
            console.error("Error loading shops:", error);
        }
        setLoading(false);
    };

    useEffect(() => {
        loadData();
    }, []);

    const owlCarouselOptions = {
        nav: false,
        dots: false,
        loop: true,
        margin: 10,
        autoplay: true,
        responsive: {
            0: {
                items: 2,
                autoplay: true,
            },
            576: {
                items: 1,
            },
            768: {
                items: 2,
            },
            992: {
                items: 2,
                autoplay: true,
            },
        },
    };

    return (
        <div className="service-catagery-list wow fadeInUp">
            <h3 className="widget_title">Available on</h3>
            <div className="faq-accordion product-accordian">
                {!loading ? (
                    shops.length > 0 ? (
                        <div className="brands" style={{ padding: "2px 0" }}>
                            <ReactOwlCarousel
                                {...owlCarouselOptions}
                                className="shopContainer owl-carousel owl-theme"
                            >
                                {shops.map((shop, index) => (
                                    <a
                                        href="#"
                                        className="shop__item"
                                        key={index}
                                    >
                                        <img
                                            src={`/frontend/images/shops/${shop.image}`}
                                            alt={shop.title}
                                            style={{ height: "100px" }}
                                            height="100%"
                                            width="100%"
                                        />
                                    </a>
                                ))}
                            </ReactOwlCarousel>
                        </div>
                    ) : (
                        <p>No shops available.</p>
                    )
                ) : (
                    <p>Loading...</p>
                )}
            </div>
        </div>
    );
};

export default AvailableShop;
