import React from "react";
import Accordion from "react-bootstrap/Accordion";
import FilterTitle from "./FilterTitle";

const MainCategory = ({ loading, categories, handleChange }) => {
    return (
        <>
            <div className="shop-category product__sidebar-single wow fadeInUp">
                <h3 className="product__sidebar-title">Shop by Categories</h3>
                <ul className="list-unstyled">
                    <Accordion defaultActiveKey="0" flush>
                        {!loading ? (
                            categories?.length > 0 ? (
                                categories?.map((category, index) => (
                                    <li key={index}>
                                        <FilterTitle
                                            item={category}
                                            type="category"
                                            className="form-check-input"
                                            handleChange={handleChange}
                                        />
                                    </li>
                                ))
                            ) : (
                                <>Loading</>
                            )
                        ) : (
                            <>Loading</>
                        )}
                    </Accordion>
                </ul>
            </div>
        </>
    );
};

export default MainCategory;
