@extends('layouts.frontend.main')

@section('title', 'Reset Password')

@section('headerTitle', 'Reset Password')

@section('header')
    <li class="breadcrumb-item active">Reset Password</li>
@endsection

@section('meta')
    <meta name="keywords"
        content="{{ get_seo_page('reset-password')->seo_keyword ? get_seo_page('reset-password')->seo_keyword : get_option('seo_meta_keywords') }}">
    <meta name="description"
        content="{{ get_seo_page('reset-password')->seo_description ? get_seo_page('reset-password')->seo_description : get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title"
        content="{{ get_seo_page('reset-password')->seo_title ? get_seo_page('reset-password')->seo_title : 'Reset Password - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description"
        content="{{ get_seo_page('reset-password')->seo_description ? get_seo_page('reset-password')->seo_description : get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title"
        content="{{ get_seo_page('reset-password')->seo_title ? get_seo_page('reset-password')->seo_title : 'Reset Password - ' . get_option('title') }}">
    <meta name="og:description"
        content="{{ get_seo_page('reset-password')->seo_description ? get_seo_page('reset-password')->seo_description : get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('content')
    <div class="container">
        <div class="login__container">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="dealer__card">

                        <div class="dealer__card-body py-5">
                            <form method="POST" class="contact-form" action="{{ route('password.update') }}">
                                @csrf

                                <input type="hidden" name="token" value="{{ $token }}">

                                <div class="col-md-12 mb-3">
                                    <label for="email" class="form-label">{{ __('Email Address') }}</label>

                                    <input id="email" type="email"
                                        class="form-control @error('email') is-invalid @enderror" name="email"
                                        value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus>

                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label for="password" class="form-label">{{ __('Password') }}</label>

                                    <input id="password" type="password"
                                        class="form-control @error('password') is-invalid @enderror" name="password"
                                        required autocomplete="new-password">

                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label for="password-confirm"
                                        class="form-label text-md-end">{{ __('Confirm Password') }}</label>

                                    <input id="password-confirm" type="password" class="form-control"
                                        name="password_confirmation" required autocomplete="new-password">
                                </div>

                                <div class="row mb-0">
                                    <button type="submit" class="btn-default">
                                        {{ __('Reset Password') }}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
