@extends('layouts.backend.main')

@section('header')
<li><a href="{{route('dashboard')}}">Dashboard</a></li>
<li class="active">Application List</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <span class="panel-title">
                    Application List
                </span>
                @can('dailywork-create')
                <div class="pull-right" style="margin-top: -6px">
                    <a href="{{ route('applications.create') }}" class="btn btn-primary ajax-modal" data-title="New Application">Add Application</a>
                </div>
                @endcan
            </div>
            <div class="panel-body table-responsive">
                <table class="table table-hover table-bordered" id="example1">
                    <thead>
                        <th>#</th>
                        <th>Application By</th>
                        <th>Reason</th>
                        <th>Leave Date</th>
                        <th>Status</th>
                        <th>Action</th>
                    </thead>
                    <tbody>
                        @foreach($applications as $key => $application)
                        <tr>
                            <td>{{ ++$key }}</td>
                            <td>{{ $application->user->name }}</td>
                            <td>{{ $application->title }}</td>
                            <td>{{date('j/F/Y', strtotime($application->leave_from)) . ' - ' . date('j/F/Y', strtotime($application->leave_to))}}</td>
                            <td>
                                @if ($application->status == 0)
                                <label class="label label-warning">Pending</label>
                                @endif
                                @if ($application->status == 1)
                                <label class="label label-success">Approved</label>
                                @endif
                                @if ($application->status == 2)
                                <label class="label label-danger">Rejected</label>
                                @endif
                            </td>
                            <td>
                                @can ('application-transfer')
                                <a href="{{route('applications.transfer', $application)}}" class="btn btn-sm btn-info ajax-modal" data-title="Transfer Application"><i class="fas fa-exchange-alt" aria-hidden="true"></i></a>
                                @endcan
                                @can ('application-edit')
                                <a href="{{route('applications.edit', $application)}}" class="btn btn-sm btn-primary ajax-modal" data-title="Edit Application"><i class="fa fa-edit"></i></a>
                                @endcan
                                @can('application-show')
                                <a href="{{route('applications.show', $application)}}" class="btn btn-sm btn-warning ajax-modal" data-title="Show Application"><i class="fa fa-eye"></i></a>
                                @endcan
                                @can('application-delete')
                                <a type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#{{$application->id}}deleteModal"><i class="fa fa-trash"></i></a>
                                <div id="{{$application->id}}deleteModal" class="delete-modal modal fade" role="dialog">
                                    <!-- Delete Modal -->
                                    <div class="modal-dialog modal-sm">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                <div class="delete-icon"></div>
                                            </div>
                                            <div class="modal-body text-center">
                                                <h4 class="modal-heading">Are You Sure ?</h4>
                                                <p>Do you really want to delete these records? This process cannot be undone.</p>
                                            </div>
                                            <div class="modal-footer">
                                                {!! Form::open(['method' => 'DELETE', 'route' => ['applications.destroy', $application]]) !!}
                                                {!! Form::reset("No", ['class' => 'btn btn-gray', 'data-dismiss' => 'modal']) !!}
                                                {!! Form::submit("Yes", ['class' => 'btn btn-danger']) !!}
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endcan

                            </td>
                        </tr>

                        @endforeach

                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>


@endsection