@extends('layouts.backend.main')

@section('header')
<li><a href="{{ route('dashboard') }}">Dashboard</a></li>
<li class="active">Staff Attendance</li>
@endsection

@section('styles')
<style media="screen">
	.switch {
		position: relative;
		display: inline-block;
		width: 50px;
		height: 28px;
	}

	.switch input {
		opacity: 0;
		width: 0;
		height: 0;
	}

	.slider {
		position: absolute;
		cursor: pointer;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		background-color: #ccc;
		-webkit-transition: .4s;
		transition: .4s;
	}

	.slider:before {
		position: absolute;
		content: "";
		height: 20px;
		width: 20px;
		left: 4px;
		bottom: 4px;
		background-color: white;
		-webkit-transition: .4s;
		transition: .4s;
	}

	input:checked+.slider {
		background-color: #2196F3;
	}

	input:focus+.slider {
		box-shadow: 0 0 1px #2196F3;
	}

	input:checked+.slider:before {
		-webkit-transform: translateX(26px);
		-ms-transform: translateX(26px);
		transform: translateX(26px);
	}

	/* Rounded sliders */
	.slider.round {
		border-radius: 34px;
	}

	.slider.round:before {
		border-radius: 50%;
	}

	.justify-content-center {
		justify-content: center !important;
	}

	.d-flex {
		display: flex !important;
	}

	.my-4 {
		margin: 15px 0;
	}
</style>
@endsection

@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<div class="panel-title">
					{{ date('d-F-Y', strtotime($dateCurrent)) }} / {{ date('h:i:s A', strtotime($dateCurrent)) }}
				</div>
				<div class="pull-right" style="margin-top: -26px;">
					<span>Check Out</span>
					<label class="switch">
						<input data-id="{{ Auth::user()->id }}" type="checkbox" class="take-attendance" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Check Out" data-off="Check In"
							{{ $attendance->status ? 'checked' : '' }}>
						<span class="slider round"></span>
					</label>
					<span>Check In</span>
				</div>
			</div>
			<div class="panel-body">
				<div class="col-md-6">
					<div id="location"> </div>
				</div>

				@if( !empty($attendance) )
				<div class="col-md-6 mt-20">
					<div class="params-panel">

						<form action="{{route('staff_attendance.save')}}" method="post" accept-charset="utf-8">
							@csrf
							<input type="hidden" name="date" value="{{$date}}">
							<input type="hidden" name="attendance_id" value="{{ $attendance->attendance_id }}">
							<input type="hidden" name="latitude" value="">
							<input type="hidden" name="longitude" value="">
							<input type="hidden" name="user_id" value="{{ $attendance->user_id }}">
							<div class="col-sm-12">
								<div class="form-group">
									<label class="control-label">Type</label>
									<select class="form-control select2" name="status" required>
										<option value="">Select One</option>
										<option {{ old('status', $attendance->checkin) != null ? 'selected' : '' }} value="1">Check In</option>
										<option {{ old('status', $attendance->checkout) != null ? 'selected' : '' }} value="0">Check Out</option>
									</select>
								</div>
							</div>
							<div class="col-sm-12">
								<div class="form-group">
									<label class="control-label">Reason</label>
									<select class="form-control select2" name="attendance" required>
										<option value="">Select One</option>
										<option {{ old('attendance') == '2' ? 'selected' : '' }} value="2">Absent</option>
										<option {{ old('attendance') == '3' ? 'selected' : '' }} value="3">Late</option>
									</select>
								</div>
							</div>
							<div class="col-sm-12">
								<div class="form-group">
									<label class="control-label">Note</label>
									<textarea name="note" rows="4" cols="40" placeholder="Note..." class="form-control" required>{{ old('note') }}</textarea>
								</div>
							</div>
							<button type="submit" class="btn btn-primary pull-right">{{('Save Attendance')}}</button>
						</form>
					</div>
				</div>
				@endif
			</div>
		</div>
	</div>
</div>
@endsection



@section('scripts')
<script type="text/javascript">
	if (!navigator.geolocation) {
		console.log("Geolocation is not supported by your browser");
	}

	function success(position) {
		var latitude = position.coords.latitude;
		var longitude = position.coords.longitude;
		$('input[name=longitude]').val(longitude);
		$('input[name=latitude]').val(latitude);
		reverseGeocodingWithGoogle(longitude, latitude)
	}

	function error() {
		toastr.error("Unable to retrieve your location");
	}
	navigator.geolocation.getCurrentPosition(success, error);

	$("input:checkbox").on('click', function() {
		var $box = $(this);
		if ($box.is(":checked")) {
			var group = "input:checkbox[name='" + $box.attr("name") + "']";
			$(group).prop("checked", false);
			$box.prop("checked", true);
		} else {
			$box.prop("checked", false);
		}
	});

	function present(source) {
		$(".absent,.late,.present,.holiday,#late_all,#absent_all,#holiday_all").prop("checked", false);
		var checkboxes = document.querySelectorAll('.present');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}

	function absent(source) {
		$(".absent,.late,.present,.holiday,#present_all,#late_all,#holiday_all").prop("checked", false);
		var checkboxes = document.querySelectorAll('.absent');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}

	function late(source) {
		$(".absent,.late,.present,.holiday,#present_all,#absent_all,#holiday_all").prop("checked", false);
		var checkboxes = document.querySelectorAll('.late');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}

	function holiday(source) {
		$(".absent,.late,.present,.holiday,#present_all,#absent_all").prop("checked", false);
		var checkboxes = document.querySelectorAll('.holiday');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}

	$(function() {
		$('.take-attendance').change(function() {
			var status = $(this).prop('checked') == true ? 1 : 0;

			if (navigator.geolocation) {
				navigator.geolocation.getCurrentPosition(showPosition);
			} else {
				console.log('Geolocation is not supported by this browser.');
			}

			function showPosition(position) {
				var longitude = position.coords.longitude;
				var latitude = position.coords.latitude;
				$.ajax({
					type: "POST",
					dataType: "json",
					url: '/dashboard/staff/attendance/save',
					data: {
						"_token": "{{ csrf_token() }}",
						'latitude': latitude,
						'longitude': longitude,
						'attendance': 1,
						'status': status,
					},
					success: function(data) {
						if (data.message) {
							for (var i = 0; i < data.message.length; i++) {
								toastr.error(data.message[i]);
							}
						}
					}
				});
			}

		})
	});
</script>
@stop