@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('blog_categories.index') }}">Blog Category List</a></li>
<li class="breadcrumb-item active">Add Blog Category</li>
@endsection

@section('content')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title mb-0">Create New Blog Category</div>
            </div>
            <div class="card-body">
                <form enctype="multipart/form-data" action="{{ route('blog_categories.store') }}" method="post">
                    @csrf
                    <div class="row g-3">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">
                                    Title <span class="text-danger">*</span>
                                </label>
                                <input class="form-control" type="text" name="title" value="{{ old('title') }}">
                            </div>
                            <!-- .input-item -->
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">
                                    Slug <span class="text-danger">*</span>
                                </label>
                                <input class="form-control" type="text" name="slug" value="{{ old('slug') }}" required>
                            </div>
                            <!-- .input-item -->
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Status <span class="text-danger">*</span> </label>
                                <select class="form-control select2" name="status">
                                    <option value="">Select One</option>
                                    <option {{ (old('status') == '1') ? 'selected' : '' }} value="1">
                                        Active
                                    </option>
                                    <option {{ (old('status') == '0') ? 'selected' : '' }} value="0">
                                        Disable
                                    </option>
                                </select>
                            </div>
                        </div>


                        <div class="col-md-12">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>

                    </div>
                </form>
            </div>
        </div>
        <!-- .card -->
    </div>
</div>
@endsection