@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('blogs.index')}}">Blog List</a></li>
<li class="breadcrumb-item active">Edit Blog</li>
@endsection

@section('content')
<form class="row g-3" method="post" action="{{ route('blogs.update', $blog) }}" enctype="multipart/form-data" autocomplete="off">
    @csrf
    @method('PUT')
    <div class="row g-4">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span>Edit a Blog</span>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="form-group col-lg-8">
                            <label class="form-label">Title <span class="text-danger">*</span> </label>
                            <input class="form-control" type="text" name="title" value="{{ old('title', $blog->title) }}" required>
                        </div>

                        <div class="form-group col-lg-4">
                            <label class="form-label">Slug <span class="text-danger">*</span> </label>
                            <input class="form-control" type="text" name="slug" value="{{ old('slug', $blog->slug) }}" required>
                        </div>

                        <div class="form-group col-lg-6">
                            <label class="form-label">Category <span class="text-danger">*</span> </label>
                            <select class="form-select select2" name="category">
                                <option value="">Select One</option>
                                @foreach ($categories as $key => $category)
                                <option {{ (old('category', $blog->category_id) == $category->id) ? 'selected' : ''}} value="{{ $category->id }}">
                                    {{ $category->title }}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-lg-6">
                            <label class="form-label">Status <span class="text-danger">*</span> </label>
                            <select class="form-select select2" name="status">
                                <option value="">Select One</option>
                                <option {{ (old('status', $blog->status) == '1') ? 'selected' : ''}} value="1">
                                    Active
                                </option>
                                <option {{ (old('status', $blog->status) == '0') ? 'selected' : ''}} value="0">
                                    Disable
                                </option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label class="form-label">Summary <span class="text-danger">*</span> </label>
                            <textarea class="form-control" type="text" name="summary" required>{{ old('summary', $blog->summary) }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="form-group col-lg-8">
                            <label class="form-label">Description <span class="text-danger">*</span> </label>
                            <textarea class="form-control summernote" type="text" name="description" required>{{ old('description', $blog->description) }}</textarea>
                        </div>
                        <div class="form-group col-lg-4">
                            <label class="form-label">Chooser an Image <span class="text-danger">*</span> </label>
                            <input class="form-control dropify" type="file" name="image" data-default-file="/frontend/images/blogs/{{ $blog->image }}" />
                        </div>
                        <div class="col-md-0">
                            <button class="btn btn-primary">Update</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection