@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('blogs.index')}}">Blog List</a></li>
<li class="breadcrumb-item active">View Blog</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Blog Details
                </span>
                @can('blog-create')
                <a href="{{ route('blogs.create') }}" class="btn btn-secondary">Add Blog</a>
                @endcan
            </div>
            <div class="card-body row">
                <div class="col-md-6  ">
                    <div class="card card-primary">
                        <div class="card-header">
                            Image
                        </div>
                        <div class="card-body">
                            <img class="img-responsive product_image" src="/frontend/images/blogs/{{ $blog->image }}" width="100%" height="auto">
                        </div>
                    </div>
                </div>

                <ul class="list-group col-md-6">
                    <li class="list-group-item">
                        <strong>Title</strong> : {{ $blog->title }}
                    </li>
                    <li class="list-group-item">
                        <strong>Category</strong> : {{ $blog->category->title }}
                    </li>
                    <li class="list-group-item">
                        <strong>Status</strong> :
                        @if ($blog->status == 1)
                        <label class="text-success p-2">Active</label>
                        @else
                        <label class="text-warning p-2">Disable</label>
                        @endif
                    </li>

                    <li class="list-group-item">
                        <strong>Created</strong> : {{ $blog->created_at->diffForHumans() }}
                    </li>
                    <li class="list-group-item">
                        <strong>Created by</strong> : {{ $blog->user->name }}
                    </li>
                    <li class="list-group-item">
                        <strong>Short Description</strong> : {{ $blog->summary }}
                    </li>

                    <li class="list-group-item">
                        <strong>Description</strong> : {!! $blog->description !!}
                    </li>
                </ul>
                @can('blog-edit')
                <a href="{{ route('blogs.edit', $blog)}}" class="btn btn-primary mt-3">
                    Edit This blog
                </a>
                @endcan
            </div>
        </div>
    </div>


</div>
@endsection