@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('brands.index')}}">Brand List</a></li>
<li class="breadcrumb-item active">View Brand</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Brand Details
                </span>
                <a href="{{ route('brands.create') }}" class="btn btn-secondary btn-sm">Add Brand</a>
            </div>
            <div class="card-body row">
                <div class="col-md-6">
                    <div class=" card panel box box-primary">
                        <div class="card-header">
                            Image
                        </div>
                        <div class="box-body">
                            <img class="img-responsive product_image" src="{{ $brand->getMedia('brand_images')->first()->getUrl() }}" width="100%" height="auto">
                        </div>
                    </div>
                </div>

                <ul class="list-group col-md-6">
                    <li class="list-group-item">
                        <strong>Name</strong> : {{ $brand->name }}
                    </li>
                    <li class="list-group-item">
                        <strong>Created</strong> : {{ $brand->created_at->diffForHumans() }}
                    </li>

                    <li class="list-group-item">
                        <strong>Created by</strong> : {{ $brand->createdBy->name }}
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection