@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item active">Brand List</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <span class="card-title">
                        Brands
                    </span>
                    @can('brand-create')
                        <div class="float-end">
                            <a href="{{ route('brands.create') }}" class="btn btn-secondary btn-sm">Add Brand</a>
                        </div>
                    @endcan
                </div>
                <div class="card-body table-responsive">
                    <table class="table table-hover table-bordered data-table" id="example1">
                        <thead>
                            <th>#</th>
                            <th>Brand Title</th>
                            <th>Status</th>
                            <th>Action</th>
                        </thead>
                        <tbody>
                            @foreach ($brands as $key => $brand)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>
                                        <span>
                                            <div class="d-flex align-items-center">
                                                @if ($brand->image)
                                                    <div class="flex-shrink-0 me-3">
                                                        <div class="avatar-sm bg-light rounded p-1 h-100"><img
                                                                src="/frontend/images/brands/{{ $brand->image ? $brand->image : '' }}"
                                                                alt="" class="img-fluid d-block"></div>
                                                    </div>
                                                @endif
                                                <div class="flex-grow-1">
                                                    <div class="fs-14 mb-1"><a href="apps-ecommerce-product-details.html"
                                                            class="text-dark">{{ $brand->title }}</a></div>
                                                    <p class="text-muted mb-0">By : <span
                                                            class="fw-medium">{{ $brand->user->name }}</span></p>
                                                </div>
                                            </div>
                                        </span>

                                    </td>
                                    <td>
                                        <div class="form-check form-switch">
                                            <input type="checkbox" role="switch" class="form-check-input"
                                                id="status{{ $key }}"
                                                onchange="saveData(event, '{{ $brand->slug }}')"
                                                {{ $brand->status ? 'checked' : '' }}>
                                            <label class="form-check-label" for="stock{{ $key }}"></label>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="{{ route('brands.edit', $brand) }}" title="Edit" class="text-link fs-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20.547 20.299"
                                                fill="currentColor" width="16">
                                                <g stroke="currentColor" stroke-width=".4">
                                                    <path data-name="Path 78"
                                                        d="M18.659 12.688a.5.5 0 00-.5.5v4.423a1.5 1.5 0 01-1.494 1.494H2.691A1.5 1.5 0 011.2 17.609V4.629a1.5 1.5 0 011.494-1.494h4.419a.5.5 0 100-1H2.691A2.493 2.493 0 00.2 4.629v12.98A2.493 2.493 0 002.691 20.1h13.976a2.493 2.493 0 002.491-2.491v-4.423a.5.5 0 00-.5-.5zm0 0">
                                                    </path>
                                                    <path data-name="Path 79"
                                                        d="M18.96.856a2.241 2.241 0 00-3.17 0L6.899 9.739a.5.5 0 00-.128.219l-1.169 4.219a.5.5 0 00.613.613l4.219-1.169a.5.5 0 00.219-.128l8.886-8.887a2.244 2.244 0 000-3.17zm-10.971 9.21l7.273-7.273 2.346 2.346-7.273 7.273zm-.469.94l1.879 1.875-2.592.718zm11.32-7.1l-.528.528-2.346-2.345.528-.528a1.245 1.245 0 011.761 0l.585.584a1.247 1.247 0 010 1.761zm0 0">
                                                    </path>
                                                </g>
                                            </svg>
                                        </a>
                                        <a href="{{ route('brands.show', $brand) }}" title="Edit"
                                            class="text-success ps-2 fs-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor" width="20">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                                </path>
                                            </svg>
                                        </a>

                                        {{-- @can('brand-delete') --}}
                                        <a type="button" title="Delete" class="text-danger fs-4 ps-2" data-toggle="modal"
                                            data-target="#deleteModal{{ $brand->id }}">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19.4 22.169"
                                                fill="currentColor" width="16">
                                                <g fill="none" stroke="currentColor" stroke-linecap="round"
                                                    stroke-linejoin="round" stroke-width="1.4">
                                                    <path data-name="Rectangle 2"
                                                        d="M8.238.7h2.923a2 2 0 012 2v.769h0-6.923 0V2.7a2 2 0 012-2z">
                                                    </path>
                                                    <path data-name="Line 1" d="M.7 3.469h18"></path>
                                                    <path data-name="Path 77"
                                                        d="M14.649 21.469h-9.9a1.385 1.385 0 01-1.38-1.279L2.085 3.469h15.231L16.029 20.19a1.385 1.385 0 01-1.38 1.279z">
                                                    </path>
                                                    <path data-name="Line 2" d="M7.623 6.238V18.7"></path>
                                                    <path data-name="Line 3" d="M11.777 6.238V18.7"></path>
                                                </g>
                                            </svg>
                                        </a>
                                        <div id="deleteModal{{ $brand->id }}" class="delete-modal modal fade"
                                            role="dialog">
                                            <!-- Delete Modal -->
                                            <div class="modal-dialog modal-sm">
                                                <div class="modal-content">
                                                    <div class="modal-body text-center">
                                                        <h4 class="modal-heading">Are You Sure ?</h4>
                                                        <p>Do you really want to delete these records? This process cannot
                                                            be undone.</p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        {!! Form::open(['method' => 'DELETE', 'route' => ['brands.destroy', $brand]]) !!}
                                                        {!! Form::reset('No', ['class' => 'btn btn-gray', 'data-dismiss' => 'modal']) !!}
                                                        {!! Form::submit('Yes', ['class' => 'btn btn-danger']) !!}
                                                        {!! Form::close() !!}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </td>
                                </tr>
                                {{-- @endcan --}}
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script type="text/javascript">
        function saveData(event, primaryid) {
            // console.log($('#' + event.target.id).val());
            var _token = $('input[name=_token]').val();
            // console.log(fieldname);
            // console.log(primaryid);
            $.ajax({
                method: "POST",
                url: '/dashboard/brands/quickedit/' + primaryid,
                data: {
                    _token: _token,
                },
                beforeSend: function() {
                    $('#preloader').css('display', 'block');
                },
                success: function(data) {
                    $('#preloader').css('display', 'none');
                    if (data.result == 'success') {
                        Command: toastr["success"](data.message)
                    }
                    else {
                        Command: toastr["error"](data.message)
                    }
                }
            });
        }
    </script>
@endsection
