@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('brands.index')}}">Brand List</a></li>
<li class="breadcrumb-item active">View Brand</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Brand Details
                </span>
                @can('brand-create')
                <a href="{{ route('brands.create') }}" class="btn btn-secondary btn-sm">Add Brand</a>
                @endcan
            </div>
            <div class="card-body">
                <div class="row g-3">

                    <ul class="list-group col-md-6">
                        <li class="list-group-item">
                            <strong>Name</strong> : {{ $brand->title }}
                        </li>
                        <li class="list-group-item">
                            <strong>Created by</strong> : {{ $brand->user->name }}
                        </li>
                        @if ($brand->image)
                        <li class="list-group-item">
                            <img src="/frontend/images/brands/{{$brand->image}}" height="150px" width="150px">
                        </li>
                        @endif
                    </ul>
                    <div class="col-lg-12">
                        @can('brand-edit')
                        <a href="{{route('brands.edit', $brand)}}" class="btn btn-primary"> Edit This Brand</a>
                        @endcan
                    </div>

                </div>
            </div>
        </div>
    </div>


</div>
@endsection