@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('candidates.index')}}">Candidate List</a></li>
<li class="breadcrumb-item active">Candidate Details</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Candidate Details
                </span>
            </div>
            <div class="card-body row">
                <ul class="list-group col-md-6">
                    <li class="list-group-item">
                        <strong>Name</strong> : {{ $candidate->name }}
                    </li>
                    <li class="list-group-item">
                        <strong>Email</strong> : {{ $candidate->email }}
                    </li>
                    <li class="list-group-item">
                        <strong>Phone</strong> : {{ $candidate->phone_number }}
                    </li>
                    <li class="list-group-item">
                        <strong>Current Address</strong> : {{ $candidate->current_address }}
                    </li>
                    <li class="list-group-item">
                        <strong>Permanent Address</strong> : {{ $candidate->permanent_address }}
                    </li>
                    <li class="list-group-item">
                        <strong>Applied Post</strong> : {{ $candidate->post_name }}
                    </li>
                    <li class="list-group-item">
                        <strong>Date of Birth</strong> : {{ $candidate->date_of_birth }}
                    </li>
                    <li class="list-group-item">
                        <strong>Gender</strong> : {{ $candidate->gender }}
                    </li>
                    <li class="list-group-item">
                        <strong>Education</strong> : {{ $candidate->education }}
                    </li>
                    <li class="list-group-item">
                        <strong>Experience</strong> : {{ $candidate->experince }}
                    </li>
                    <li class="list-group-item">
                        <strong>Date Applied</strong> : {{ $candidate->created_at->format('F, j, m, Y') }}
                    </li>
                    <li class="list-group-item">
                        <strong> Uploaded CV</strong> :
                        <a href="{{ $candidate->resumeUrl }}" target="_blank" class="btn btn-primary ">View Uploaded CV </a>

                    </li>
                </ul>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">
                                About candidate
                            </div>
                        </div>
                        <div class="card-body">
                            {{ $candidate->remarks }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection