@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('catalogues.index') }}">Catalogue list</a></li>
<li class="breadcrumb-item active">New Catalogue</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <div class="card-title">Create New Catalogue</div>
            </div>
            <div class="card-body">
                <form class="" method="post" action="{{route('catalogues.store')}}" enctype="multipart/form-data">
                    {{csrf_field()}}
                    <div class="row g-3">
                        <div class="col-md-8">
                            <div class="row g-3">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form-label">Title <span class="text-danger">*</span> </label>
                                        <input class="form-control" type="text" name="title" value="{{ old('title') }}" required />
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <label class="form-label">Slug <span class="text-danger">*</span> </label>
                                    <input type="text" class="form-control" name="slug" value="{{ old('slug') }}" required />
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">PDF File <span class="text-danger">*</span> </label>
                                        <input class="form-control appsvan-file" type="file" accept=".pdf" name="file" required />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Status</label>
                                    <select class="form-select select2" name="status">
                                        <option value="">Select One</option>
                                        <option {{ (old('status') == '1') ? 'selected' : '' }} value="1">
                                            Active
                                        </option>
                                        <option {{ (old('status') == '0') ? 'selected' : '' }} value="0">
                                            Disable
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <button class="btn btn-primary">Submit</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="row g-3">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form-label">Featured Image <span class="text-danger">*</span> </label>
                                        <input type="file" class="form-control dropify" name="image" required />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
@endsection