@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('catalogues.index') }}">Catalogue List</a></li>
<li class="breadcrumb-item active">Edit Catalogue</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <div class="card-title">Edit Catalogue Details</div>
            </div>
            <div class="card-body">
                <form class="row g-3" method="post" action="{{route('catalogues.update', $catalogue)}}" enctype="multipart/form-data">
                    @method('PUT')
                    {{csrf_field()}}

                    <div class="col-md-8 row g-3">
                        <div class="col-md-12">
                            <label class="form-label">Title <span class="text-danger">*</span> </label>
                            <input class="form-control" type="text" name="title" value="{{ old('title', $catalogue->title) }}" required>
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Slug <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control" name="slug" value="{{ old('slug', $catalogue->slug) }}" required />
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">PDF File <span class="text-danger">*</span> </label>
                                <input class="form-control appsvan-file" type="file" data-value="{{ $catalogue->file }}" name="file" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Status</label>
                            <select class="form-select select2" name="status">
                                <option value="">Select One</option>
                                <option {{ (old('status', $catalogue->status) == '1') ? 'selected' : '' }} value="1">
                                    Active
                                </option>
                                <option {{ (old('status', $catalogue->status) == '0') ? 'selected' : '' }} value="0">
                                    Disable
                                </option>
                            </select>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 row g-3">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Featured Image <span class="text-danger">*</span> </label>
                                <input type="file" class="form-control dropify" name="image" data-default-file="/frontend/images/catalogues/{{ $catalogue->image }}" />
                            </div>
                        </div>
                    </div>
                </form>
            </div>


        </div>
    </div>
</div>
@endsection