@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('catalogues.index') }}">Catalogue List</a></li>
<li class="breadcrumb-item active">View Catalogue Details</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <div class="card-title">
                    Catalogue Details
                </div>
                <a href="{{ route('catalogues.create') }}" class="btn btn-secondary pull-right">Add catalogue</a>
            </div>
            <div class="card-body row">
                <div class="col-md-6 pull-right">
                    <div class="card card-primary">
                        <div class="card-header">
                            Image
                        </div>
                        <div class="card-body">
                            <img class="w-100" src="/frontend/images/catalogues/{{ $catalogue->image }}">
                        </div>
                    </div>
                </div>

                <ul class="list-group col-md-6">
                    <li class="list-group-item">
                        <strong>Title</strong> : {{ $catalogue->title }}
                    </li>
                    <li class="list-group-item">
                        <strong>PDF File</strong> :
                        @if ($catalogue->file!="" )
                        <a href="/frontend/images/catalogues/{{ $catalogue->file }}" class="text-info fs-5  px-2" download title="Download Catalogue">
                            <i class="fa fa-download"></i>
                        </a>
                        @endif
                    </li>
                    <li class="list-group-item">
                        <strong>Status</strong> :
                        @if ($catalogue->status == 1)
                        <label class="text-success p-2">Active</label>
                        @else
                        <label class="text-warning p-2">Disable</label>
                        @endif
                    </li>
                    <li class="list-group-item">
                        <strong>Created By</strong> : {{ $catalogue->user->name }}
                    </li>
                    <li class="list-group-item">
                        <strong>Created At</strong> : {{ $catalogue->created_at->format('d M, Y') }}
                    </li>
                </ul>
                <div>
                    <br>
                    <a href="{{route('catalogues.edit', $catalogue)}}" class="btn btn-primary"> Edit This catalogue</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection