@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('contact_persons.index') }}">Contact List</a></li>
<li class="breadcrumb-item active">Edit Contact List </li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <div class="card-title">
                    Edit Contact List
                </div>
            </div>
            <div class="card-body">
                <form class="row g-3" action="{{ route('contact_persons.update', $contactPerson) }}" method="post">
                    @csrf
                    @method('put')
                    <div class="form-group col-md-12">
                        <label class="control-label">Contact Person</label>
                        <input type="text" class="form-control" name="contact_person" required value="{{ old('contact_person', $contactPerson->contact_person) }}">
                    </div>
                    <div class="form-group col-md-4 {{ $errors->has('date_of_birth') ? ' has-error' : '' }}">
                        <label class="control-label">Date Of Birth </label>
                        <input type="text" class="form-control datepicker" name="date_of_birth" placeholder="Date of Birth" value="{{ old('date_of_birth', $contactPerson->date_of_birth) }}">
                    </div>
                    <div class="form-group col-md-4">
                        <label class="control-label">Address</label>
                        <input type="text" class="form-control" name="address" required value="{{ old('address', $contactPerson->address) }}">
                    </div>
                    <div class="form-group col-md-4">
                        <label class="control-label">Email Address</label>
                        <input type="text" class="form-control" name="email" value="{{ old('email', $contactPerson->email) }}">
                    </div>
                    <div class="form-group col-md-4">
                        <label class="control-label">Phone Number</label>
                        <input type="text" class="form-control" name="phone_number" required value="{{ old('phone_number', $contactPerson->phone_number) }}">
                    </div>
                    <div class="form-group col-md-4 {{ $errors->has('landline_number') ? ' has-error' : '' }}">
                        <label class="control-label">Landline</label>
                        <input type="text" class="form-control" name="landline_number" placeholder="Landline Number" value="{{ old('landline_number', $contactPerson->landline_number) }}">
                    </div>
                    <div class="form-group col-md-4 {{ $errors->has('company_name') ? ' has-error' : '' }}">
                        <label class="control-label">Company</label>
                        <input type="text" class="form-control" name="company_name" placeholder="Company Name" value="{{ old('company_name', $contactPerson->company_name) }}">
                    </div>
                    <div class="form-group col-md-4 {{ $errors->has('pan_no') ? ' has-error' : '' }}">
                        <label class="control-label">PAN No</label>
                        <input type="text" class="form-control" name="pan_no" placeholder="PAN No" value="{{ old('pan_no', $contactPerson->pan_no) }}">
                    </div>
                    <div class="form-group col-md-4 {{ $errors->has('project') ? ' has-error' : '' }}">
                        <label class="control-label">Project</label>
                        <input type="text" class="form-control" name="project" placeholder="Project" value="{{ old('project', $contactPerson->project) }}">
                    </div>
                    <div class="form-group col-md-4 {{ $errors->has('position') ? ' has-error' : '' }}">
                        <label class="control-label">Position</label>
                        <input type="text" class="form-control" name="position" placeholder="Position" value="{{ old('position', $contactPerson->position) }}">
                    </div>
                    <div class="form-group col-md-12">
                        <button type="submit" class="btn btn-success">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection