<!-- Right side column. Contains the navbar and content of the page -->
<div class="row g-3">
    <div class="col-md-12">
        <div class="row g-3">
            @can('product-list')
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="{{ route('products.index') }}" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Products
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        {{ get_products()->count() }}
                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-cube-alt'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @endcan

            @can('offer-list')
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="{{ route('offers.index') }}" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Offers
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        {{ get_offers()->count() }}
                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-gift'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @endcan

            @can('shop-list')
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="{{ route('shops.index') }}" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Shops
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        {{ get_shops()->count() }}
                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-home-smile'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @endcan
            @can('user-list')
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="{{ route('users.index') }}" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Users
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        {{ get_users()->count() }}
                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-user'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @endcan



            @can('candidate-list')
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="{{ route('candidates.index') }}" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Career Request
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        {{ get_candidates()->count() }}
                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-user-pin'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @endcan

            @can('contact-us-list')
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="{{ route('contact_forms.index') }}" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Contact Request
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        {{ get_contact_forms()->count() }}
                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-user-voice'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @endcan

            @can('subscriber-list')
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="{{ route('subscribers.index') }}" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Subscriber
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        {{ get_subscribers()->count() }}
                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-file'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @endcan

            @can('admin-setting')
                <div class="col-xl-3 col-md-6 col-sm-6">
                    <a href="{{ route('general.settings') }}" class="card card-animate">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                        Setting
                                    </p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-3">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-3">
                                        -
                                    </h4>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class='bx bx-cog'></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @endcan
        </div>
    </div>


    @can('product-request-list')
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white">
                    <div class="card-title mb-0">
                        <h2 class="fs-5 mb-0 text-dark">Product Request</h2>
                    </div>
                    <a href="{{ route('product_requests.index') }}" class="btn btn-success align-items-center">More <i
                            class='bx bx-right-arrow-alt'></i></a>
                </div>
                <div class="card-body p-0">
                    <div class=" pb-0">
                        <table class="table table-bordered table-responsive table-hover align-items-center">
                            <thead>
                                <tr>
                                    <td>Product</td>
                                    <td>Date</td>
                                </tr>
                            </thead>
                            <tbody>
                                @if (get_product_requests())
                                    @foreach (get_product_requests()->take(5) as $key => $item)
                                        <tr>
                                            <td>
                                                <div class="d-flex">
                                                    <div class="">
                                                        <img style="width: 60px; height: 60px;"
                                                            src="{{ $item->product ? $item->product->imageUrl : '' }}"
                                                            alt="">
                                                    </div>
                                                    <div class="ps-3">
                                                        <div class="">
                                                            {{ $item->product ? $item->product->title : '-' }}
                                                        </div>
                                                        <div class="text-muted">
                                                            {{ $item->name }}
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{ $item->created_at->format('d M, Y') }}</td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endcan

    @can('offer-request-list')

        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white">
                    <div class="card-title mb-0">
                        <h2 class="fs-5 mb-0 text-dark">Offer Request</h2>
                    </div>
                    <a href="{{ route('offer_requests.index') }}" class="btn btn-success align-items-center">More <i
                            class='bx bx-right-arrow-alt'></i></a>
                </div>
                <div class="card-body p-0">
                    <div class=" pb-0">
                        <table class="table table-bordered table-responsive table-hover align-items-center">
                            <thead>
                                <tr>
                                    <td>Product</td>
                                    <td>Date</td>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (get_offer_requests()->take(5) as $key => $item)
                                    <tr>
                                        <td>
                                            <div class="d-flex">
                                                <div class="">
                                                    <img style="width: 60px; height: 60px;"
                                                        src="{{ $item->offer->imageUrl }}" alt="">
                                                </div>
                                                <div class="ps-3">
                                                    <div class="">
                                                        {{ $item->offer->title }}
                                                    </div>
                                                    <div class="text-muted">
                                                        {{ $item->name }}
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ $item->created_at->format('d M, Y') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endcan

    @can('dealer-enquiry-list')
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white">
                    <div class="card-title mb-0">
                        <h2 class="fs-5 mb-0 text-dark">Dealer Enquiry</h2>
                    </div>
                    <a href="{{ route('dealer_enquiries.index') }}" class="btn btn-success align-items-center">More <i
                            class='bx bx-right-arrow-alt'></i></a>
                </div>
                <div class="card-body p-0">
                    <div class=" pb-0">
                        <table class="table table-bordered table-responsive table-hover align-items-center">
                            <thead>
                                <tr>
                                    <td>Full Name</td>
                                    <td>Company</td>
                                    <td>Date</td>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (get_dealer_enquiries()->take(5) as $key => $item)
                                    <tr>
                                        <td>
                                            <div class="d-flex">
                                                <div class="ps-3">
                                                    <div class="">
                                                        {{ $item->name }}
                                                    </div>
                                                    <div class="text-muted">
                                                        {{ $item->phone }}
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ $item->company_name }}</td>
                                        <td>{{ $item->created_at->format('d M, Y') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endcan

    @can('dealer-enquiry-list')
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white">
                    <div class="card-title mb-0">
                        <h2 class="fs-5 mb-0 text-dark">Customer Enquiry</h2>
                    </div>
                    <a href="{{ route('customer_enquiries.index') }}" class="btn btn-success align-items-center">More <i
                            class='bx bx-right-arrow-alt'></i></a>
                </div>
                <div class="card-body p-0">
                    <div class=" pb-0">
                        <table class="table table-bordered table-responsive table-hover align-items-center">
                            <thead>
                                <tr>
                                    <td>Full Name</td>
                                    <td>Address</td>
                                    <td>Date</td>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (get_customer_enquiries()->take(5) as $key => $item)
                                    <tr>
                                        <td>
                                            <div class="d-flex">
                                                <div class="ps-3">
                                                    <div class="">
                                                        {{ $item->name }}
                                                    </div>
                                                    <div class="text-muted">
                                                        {{ $item->phone }}
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ $item->address }}</td>
                                        <td>{{ $item->created_at->format('d M, Y') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endcan

</div><!-- /.content-wrapper -->

{{-- <div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="header">
                <h4 class="title text-center">{{ ('Order Summary of')." ".date("Y") }}</h4>
</div>
<div class="content">
    <div id="income_vs_expense_chart" style="width: 100%; height:400px;"></div>
</div>
</div>
</div>
</div>
<script type="text/javascript">
    var yearly_income = {
        {
            $data['yearly_order']
        }
    };
</script> --}}
