@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item active">Dealer Enquiry</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Dealer Enquiry List
                </div>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-hovered data-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Company Name</th>
                            <th>Phone</th>
                            <th>Address</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($enquiries as $key => $dealer)
                        <tr>
                            <td>{{ ++$key }}</td>
                            <td>{{ $dealer->name }}</td>
                            <td>{{ $dealer->company_name }}</td>
                            <td>{{ $dealer->phone }}</td>
                            <td>{{ $dealer->address }}</td>
                            <td>
                                <a href="{{route('dealer_enquiries.show', $dealer)}}" rel="noopener noreferrer" class="text-secondary fs-5 pe-2" title="View  Details">
                                    <i class="fa fa-eye"></i>
                                </a>

                                @can ('dealer-enquiry-delete')
                                <a type="button" class="text-danger fs-4" data-bs-toggle="modal" data-bs-target="#deleteModal{{$dealer->id}}">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19.4 22.169" fill="currentColor" width="16">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.4">
                                            <path data-name="Rectangle 2" d="M8.238.7h2.923a2 2 0 012 2v.769h0-6.923 0V2.7a2 2 0 012-2z"></path>
                                            <path data-name="Line 1" d="M.7 3.469h18"></path>
                                            <path data-name="Path 77" d="M14.649 21.469h-9.9a1.385 1.385 0 01-1.38-1.279L2.085 3.469h15.231L16.029 20.19a1.385 1.385 0 01-1.38 1.279z"></path>
                                            <path data-name="Line 2" d="M7.623 6.238V18.7"></path>
                                            <path data-name="Line 3" d="M11.777 6.238V18.7"></path>
                                        </g>
                                    </svg>
                                </a>
                                <div id="deleteModal{{$dealer->id}}" class="delete-modal modal fade" role="dialog">
                                    <!-- Delete Modal -->
                                    <div class="modal-dialog modal-sm">
                                        <div class="modal-content">
                                            <div class="modal-body text-center">
                                                <h4 class="modal-heading">Are You Sure ?</h4>
                                                <p>Do you really want to delete these records? This process cannot be undone.</p>
                                            </div>
                                            <div class="modal-footer">
                                                {!! Form::open(['method' => 'DELETE', 'route' => ['dealer_enquiries.destroy', $dealer]]) !!}
                                                {!! Form::reset("No", ['class' => 'btn btn-gray', 'data-bs-dismiss' => 'modal']) !!}
                                                {!! Form::submit("Yes", ['class' => 'btn btn-danger']) !!}
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endcan
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection