@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"> <a href="{{ route('dealer_enquiries.index') }}">Dealer Enquiry</a> </li>
<li class="breadcrumb-item">View Dealer Enquiry Details</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Dealer Enquiry Details
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <ul class="list-group">
                            <li class="list-group-item"> <strong class="pe-3">Full Name : </strong> {{ $dealerEnquiry->name }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Company Name : </strong> {{ $dealerEnquiry->company_name }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Address : </strong> {{ $dealerEnquiry->address }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Email Address : </strong> {{ $dealerEnquiry->email }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Phone No. : </strong> {{ $dealerEnquiry->phone }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Applied On : </strong> {{ $dealerEnquiry->created_at ? $dealerEnquiry->created_at->format('d M, Y') : null }} </li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Query
                                </div>
                            </div>
                            <div class="card-body">
                                {{ $dealerEnquiry->message }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection