@extends('layouts.backend.main')

@section('header')
<li><a href="{{ route('dashboard') }}">Dashboard</a></li>
<li class="active">Mail Settings</li>
@endsection

@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<div class="panel-title">
					Mail Settings
				</div>
			</div>
			<div class="panel-body">
				<form action="{{ route('email.setting') }}" class="form-groups-bordered validate" autocomplete="off" method="post" accept-charset="utf-8">
					{{csrf_field()}}
					<div class="col-md-6">
						<div class="form-group {{ $errors->has('from_name') ? ' has-error' : '' }}">
							<label class="control-label">Email From</label>
							<input type="text" class="form-control" name="from_name" value="{{ get_option('from_name') }}" required>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group {{ $errors->has('from_email') ? ' has-error' : '' }}">
							<label class="control-label">Email Address</label>
							<input type="text" class="form-control" name="from_email" value="{{ get_option('from_email') }}" required>
						</div>
					</div>

					<div class="col-md-6">
						<div class="form-group {{ $errors->has('mail_type') ? ' has-error' : '' }}">
							<label class="control-label">Mail Type</label>
							<input type="text" class="form-control" name="mail_type" value="{{ get_option('mail_type') }}" required>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group {{ $errors->has('smtp_encryption') ? ' has-error' : '' }}">
							<label class="control-label">SMTP Encryption</label>
							<input type="text" class="form-control" name="smtp_encryption" value="{{ get_option('smtp_encryption') }}" required>
						</div>
					</div>

					<div class="col-md-6">
						<div class="form-group {{ $errors->has('smtp_host') ? ' has-error' : '' }}">
							<label class="control-label">SMTP Host</label>
							<input type="text" class="form-control" name="smtp_host" value="{{ get_option('smtp_host') }}" required>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group {{ $errors->has('smtp_port') ? ' has-error' : '' }}">
							<label class="control-label">SMTP Port</label>
							<input type="text" class="form-control" name="smtp_port" value="{{ get_option('smtp_port') }}" required>
						</div>
					</div>

					<div class="col-md-6">
						<div class="form-group {{ $errors->has('smtp_username') ? ' has-error' : '' }}">
							<label class="control-label">Email</label>
							<input type="text" class="form-control" name="smtp_username" value="{{ get_option('smtp_username') }}" required>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group {{ $errors->has('smtp_password') ? ' has-error' : '' }}">
							<label class="control-label">Password</label>
							<input type="password" class="form-control" name="smtp_password" value="{{ get_option('smtp_password') }}" required>
						</div>
					</div>

					<div class="col-sm-offset-0 col-sm-9">
						<div class="form-group">
							<button type="submit" class="btn btn-info">Update</button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection