@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"> <a href="{{ route('events.index') }}">Event List</a> </li>
    <li class="breadcrumb-item active">View Event</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        Event Details
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <ul class="list-group">
                                <li class="list-group-item text-center">
                                    <img style="height: 120px; object-fit: contain" src="{{ $event->imageUrl }}"
                                        alt="">
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Title : </strong> {{ $event->title }}
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Location : </strong> {{ $event->location }}
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Status : </strong>
                                    @if ($event->status == 1)
                                        <label class="text-success p-2">Active</label>
                                    @else
                                        <label class="text-warning p-2">Disable</label>
                                    @endif
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Created At:</strong>
                                    {{ $event?->created_at?->format('d M, Y') }}
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Description : </strong> {!! $event->description !!}
                                </li>
                            </ul>
                        </div>

                        <div class="col-md-6">
                            @if (count(json_decode($event->images) ?? []))
                                <div class="row g-4">
                                    @foreach (json_decode($event->images) as $item)
                                        <div class="col-md-6">
                                            <img class="w-100" src="/frontend/images/events/{{ $item }}"
                                                alt="">
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
