@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"> <a href="{{ route('faqs.index') }}"> Faq List </a> </li>
<li class="breadcrumb-item"><a href="{{route('faq_types.index')}}">Type List</a></li>
<li class="breadcrumb-item active">Add Type</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Create Type</span>
            </div>
            <div class="card-body">
                <div class="params-panel">
                    <form class="row g-3" method="post" enctype="multipart/form-data" action="{{route('faq_types.store')}}">
                        @csrf
                        <div class="col-md-12">
                            <div class=" row g-3">
                                <div class="form-group col-md-8">
                                    <label class="form-label">Title</label>
                                    <input class="form-control" type="text" name="title" value="{{ old('title') }}" required>
                                </div>
                                <div class="form-group col-md-4">
                                    <label class="form-label">Status</label>
                                    <select class="form-select select2" name="status">
                                        <option value="">Select One</option>
                                        <option {{ (old('status') == '1') ? 'selected' : '' }} value="1">Active</option>
                                        <option {{ (old('status') == '0') ? 'selected' : '' }} value="0">Disable</option>
                                    </select>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-0">
                            <button class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection