@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"> <a href="{{ route('faqs.index') }}"> Faq List </a> </li>
<li class="breadcrumb-item"><a href="{{route('faq_types.index')}}">Type List</a></li>
<li class="breadcrumb-item active">Show Type</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Show Type</span>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-5">
                        <ul class="list-group">
                            <li class="list-group-item"> <strong class="pe-3">Title :</strong> {{ $faqType->title }}</li>
                            <li class="list-group-item"> <strong class="pe-3">Created By :</strong> {{ $faqType->user->name }}</li>
                            <li class="list-group-item"> <strong class="pe-3">Created On :</strong> {{ $faqType->created_at->format('d M, Y') }}</li>
                            <li class="list-group-item"> <strong class="pe-3">Status :</strong>
                                @if ($faqType->status == 0)
                                <span class="text-success">Active</span>
                                @else
                                <span class="text-warning">Disable</span>
                                @endif
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-7">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Faqs
                                </div>
                            </div>
                            <div class="card-body">
                                <ul class="list-group">
                                    @forelse ($faqType->faqs as $key => $faq)
                                    <li class="list-group-item"> <strong class="pe-3">Title :</strong> {{ $faq->title }}</li>
                                    <li class="list-group-item"> <strong class="pe-3">Status :</strong>
                                        @if ($faq->status == 0)
                                        <span class="text-success">Active</span>
                                        @else
                                        <span class="text-warning">Disable</span>
                                        @endif
                                    </li>
                                    @empty

                                    <li class="list-group-item text-center"> No faq found</li>

                                    @endforelse
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection