@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"> <a href="{{ route('faqs.index') }}"> Faq List </a> </li>
<li class="breadcrumb-item active">Edit Faq</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Edit Faq</span>
            </div>
            <div class="card-body">
                <div class="params-panel">
                    <form class="row g-3" method="post" enctype="multipart/form-data" action="{{route('faqs.update', $faq)}}">
                        @csrf
                        @method('put')
                        <div class="col-md-12">
                            <div class=" row g-3">
                                <div class="col-md-8">
                                    <div class="row g-3">
                                        <div class="form-group col-md-12">
                                            <label class="form-label">Question <span class="text-danger">*</span> </label>
                                            <input class="form-control" type="text" name="question" value="{{ old('question', $faq->question) }}" required>
                                        </div>

                                        <div class="form-group col-md-12">
                                            <label class="form-label">Answer <span class="text-danger">*</span> </label>
                                            <textarea class="form-control" name="answer" rows="8" cols="80">{{ old('answer', $faq->answer) }}</textarea>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-md-4">
                                    <div class="row g-3">
                                        <div class="form-group col-md-12">
                                            <label class="form-label">Type <span class="text-danger">*</span> </label>
                                            <select class="form-select select2" name="faq_type">
                                                <option value="">Select One</option>
                                                @foreach (get_faq_types() as $key => $type)
                                                <option {{ (old('faq_type', $faq->faq_type_id) == $type->id) ? 'selected' : '' }} value="{{ $type->id }}">
                                                    {{ $type->title }}
                                                </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-md-12">
                                            <label class="form-label">Status <span class="text-danger">*</span> </label>
                                            <select class="form-select select2" name="status">
                                                <option value="">Select One</option>
                                                <option {{ (old('status', $faq->status) == '1') ? 'selected' : '' }} value="1">Active</option>
                                                <option {{ (old('status', $faq->status) == '0') ? 'selected' : '' }} value="0">Disable</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>



                            </div>
                        </div>
                        <div class="col-md-0">
                            <button class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection