@extends('layouts.backend.main')

@section('header')
<li><a href="{{ route('dashboard') }}">Dashboard</a></li>
<li class="active">Icons List</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <span class="panel-title">Icons List</span>
                <div class="pull-right" style="margin-top: -6px">
                    <a href="{{ route('icons.create') }}" class="btn btn-primary ajax-modal" data-title="Add New Icon">Add Icon</a>
                </div>
            </div>
            <div class="panel-body">
                @forelse ($icons as $icon)
                <div class="member">
                    <div class="member-pic set-bg" data-setbg="{{ $icon->image_url }}" style="margin: 8px;">
                        <img class="member-pic set-bg rounded p-0" src="{{ $icon->image_url }}">
                        <div class="member-social">
                            {!! Form::open(['method' => 'DELETE', 'route' => ['icons.destroy', $icon]]) !!}
                            <a href="{{ route('icons.show', $icon) }}" class="ajax-modal" data-title="View Icon">
                                <i class="fa fa-eye"></i>
                            </a>
                            <a class="ajax-modal" href="{{ route('icons.edit', $icon) }}" data-title="Edit Icon">
                                <i class="fa fa-edit"></i>
                            </a>
                            <button type="submit">
                                <i class="fa fa-trash"></i>
                            </button>
                            {!! Form::close() !!}
                        </div>
                    </div>
                    <div class="mb-5" style="margin-top: -5px;"><strong>{{ $icon->title }}</strong></div>
                </div>
                @empty
                <div class="col-md-12 alert rounded alert-danger btn-l text-center">
                    No Data Found
                </div>
                @endforelse
            </div>
        </div>
    </div>
</div>
@endsection