@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('joblists.index')}}">Job List</a></li>
<li class="breadcrumb-item active">Update Job</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Add Job</span>
            </div>
            <div class="card-body">
                <div class="params-panel">
                    <form class="row g-3" method="post" action="{{route('joblists.update', $joblist)}}" enctype="multipart/form-data">
                        @csrf
                        @method('put')
                        <div class="col-md-8">
                            <div class="form-group">
                                <label class="form-label">Title</label>
                                <input class="form-control" type="text" name="title" value="{{ old('title', $joblist->title) }}" required>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Slug <span class="text-danger">*</span> </label>
                                <input class="form-control" type="text" name="slug" value="{{ old('slug', $joblist->slug) }}" required>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Type <span class="text-danger">*</span> </label>
                            <select class="form-select select2" name="time" required>
                                <option value="">Select One</option>
                                <option {{ (old('time', $joblist->time) == "Part Time") ? 'selected' : '' }} value="Part Time">
                                    Part Time
                                </option>
                                <option {{ (old('time', $joblist->time) == "Full Time") ? 'selected' : '' }} value="Full Time">
                                    Full Time
                                </option>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Salary <span class="text-danger">*</span> </label>
                                <input class="form-control" type="text" name="salary" value="{{ old('salary', $joblist->salary) }}" required>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Education <span class="text-danger">*</span> </label>
                                <input class="form-control" type="text" name="education" value="{{ old('education', $joblist->education) }}" required>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Experince <span class="text-danger">*</span> </label>
                                <input class="form-control" type="text" name="experince" value="{{ old('experince', $joblist->experince) }}" required>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">No. of Vacancy <span class="text-danger">*</span> </label>
                                <input class="form-control" type="text" name="no_of_vacancy" value="{{ old('no_of_vacancy', $joblist->no_of_vacancy) }}" required>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Status <span class="text-danger">*</span> </label>
                            <select class="form-select select2" name="status" required>
                                <option value="">Select One</option>
                                <option {{ (old('status', $joblist->status) == "1") ? 'selected' : '' }} value="1">
                                    Active
                                </option>
                                <option {{ (old('status', $joblist->status) == "0") ? 'selected' : '' }} value="0">
                                    Disable
                                </option>
                            </select>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Description <span class="text-danger">*</span></label>
                                <textarea name="description" class="form-control summernote" rows="8" cols="80" required>{{ old('description', $joblist->description) }}</textarea>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <button class="btn btn-primary">Update Job</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection