@extends('layouts.backend.main')

@section('header')
<li><a href="{{ route('dashboard') }}">Dashboard</a></li>
<li><a href="{{ route('kycs.index') }}">KYC List</a></li>
<li class="active">KYC Profile</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                {{ $customer->name }} Profile
            </div>
            <div class="panel-body">
                <div class="params-label">
                    <table class="table table-striped table-bordered" width="100%">
                        <tbody>
                            <tr>
                                <td style="text-align: center;" colspan="4">
                                    <img width="200px" height="200px" style="border-radius: 7px;" src="/frontend/images/photo/{{($customer->name . '/' . $customer->photo) }}">
                                </td>
                            </tr>
                            <tr>
                                <td>Full Name</td>
                                <td colspan="3">{{$customer->name}}</td>
                            </tr>
                            <tr>
                                <td>Date of Birth</td>
                                <td>{{$customer->birthday}}</td>
                                <td>Gender</td>
                                <td>{{$customer->gender}}</td>
                            </tr>
                            <tr>
                                <td>Father's Name</td>
                                <td>{{$customer->father_name}}</td>
                                <td>Grand Father's Name</td>
                                <td>{{$customer->grand_father_name}}</td>
                            </tr>
                            <tr>
                                <td>Phone</td>
                                <td>{{ $customer->contact_no }}</td>
                                <td>Email</td>
                                <td>{{ $customer->email }}</td>
                            </tr>
                            <tr>
                                <td>Blood Group</td>
                                <td>{{$customer->blood_group}}</td>
                                <td>Maritual Status</td>
                                <td>{{$customer->maritual_status}}</td>
                            </tr>
                            <tr>
                                <td>Nationality</td>
                                <td>{{$customer->nationality}}</td>
                                <td>Parmanent Address</td>
                                <td>{{ $customer->permanent_municipality }} -{{ $customer->permanent_wardno }}, {{ $customer->permanent_city }}, {{$customer->permanent_district}}</td>
                            </tr>
                            <tr>
                                <td>Current Address</td>
                                <td>{{ $customer->temporary_address }} - {{ $customer->temporary_ward }}</td>
                            </tr>
                            <tr>
                                <td colspan="4"><strong>Company Joining Details</strong></td>
                            </tr>
                            <tr>
                                <td>Company Name</td>
                                <td>{{$customer->company_name}}</td>
                                <td>Supervisor Name</td>
                                <td>{{$customer->supervisor_name}}</td>
                            </tr>
                            <tr>
                                <td>Appointed Place</td>
                                <td>{{$customer->appointed_place}}</td>
                                <td>Date of Join</td>
                                <td>{{$customer->joining_date}}</td>
                            </tr>
                            <tr>
                                <td colspan="4"><strong>Alternative Contact Details</strong></td>
                            </tr>
                            <tr>
                                <td>Name of Family Member</td>
                                <td colspan="3">{{$customer->family_member}}</td>
                            </tr>
                            <tr>
                                <td>Contact Number</td>
                                <td>{{$customer->family_contact}}</td>
                                <td>Relationship</td>
                                <td>{{$customer->relationship}}</td>
                            </tr>
                            <tr>
                                <td colspan="2">Citizenship</td>
                                <td colspan="2">Designature</td>
                            </tr>
                            <tr>
                                <td style="text-align: center;" colspan="2">
                                    <a href="{{ asset('/frontend/images/citizenship/'.$customer->name . '/'.$customer->citizenship_right) }}" target="_blank">
                                        <img width="200px" style="border-radius: 7px;height:200px" src="/frontend/images/citizenship/{{($customer->name. '/' . $customer->citizenship_right) }}">
                                    </a>
                                    <a href="{{ asset('/frontend/images/citizenship/'.$customer->name . '/'.$customer->citizenship_left) }}" target="_blank">
                                        <img width="200px" style="border-radius: 7px;height:200px" src="/frontend/images/citizenship/{{($customer->name. '/' . $customer->citizenship_left) }}">
                                    </a>
                                </td>
                                <td style="text-align: center;" colspan="2">
                                    <a href="{{ asset('/frontend/images/designature/'.$customer->name . '/'.$customer->designature) }}" target="_blank">
                                        <img width="200px" style="border-radius: 7px;height:200px" src="/frontend/images/designature/{{($customer->name. '/' . $customer->designature) }}">
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <a href="{{ asset('/frontend/images/citizenship/'.$customer->name . '/'.$customer->citizenship_right) }}" class="btn btn-primary btn-sm" download>Right Download</a>
                                    <a href="{{ asset('/frontend/images/citizenship/'.$customer->name . '/'.$customer->citizenship_left) }}" class="btn btn-danger btn-sm" target="_blank">Left Download</a>
                                </td>
                                <td colspan="2">
                                    <a href="{{ asset('/frontend/images/designature/'.$customer->name . '/'.$customer->designature) }}" class="btn btn-primary btn-sm" download>Download</a>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">Lincense</td>
                                <td colspan="2">Passport</td>
                            </tr>
                            <tr>
                                <td style="text-align: center;" colspan="2">
                                    <a href="{{ asset('/frontend/images/lincense/'.$customer->name . '/'.$customer->lincense_left) }}" target="_blank">
                                        <img width="200px" style="border-radius: 7px;height:200px" src="/frontend/images/lincense/{{($customer->name . '/' . $customer->lincense_left) }}">
                                    </a>
                                    <a href="{{ asset('/frontend/images/lincense/'.$customer->name . '/'.$customer->lincense_right) }}" target="_blank">
                                        <img width="200px" style="border-radius: 7px;height:200px" src="/frontend/images/lincense/{{($customer->name . '/' . $customer->lincense_right) }}">
                                    </a>
                                </td>
                                <td style="text-align: center;" colspan="2">
                                    <a href="{{ asset('/frontend/images/passport/'.$customer->name . '/'.$customer->passport_left) }}" target="_blank">
                                        <img width="200px" style="border-radius: 7px;height:200px" src="/frontend/images/passport/{{($customer->name . '/' . $customer->passport_left) }}">
                                    </a>
                                    <a href="{{ asset('/frontend/images/passport/'.$customer->name . '/'.$customer->passport_right) }}" target="_blank">
                                        <img width="200px" style="border-radius: 7px;height:200px" src="/frontend/images/passport/{{($customer->name . '/' . $customer->passport_right) }}">
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <a href="{{ asset('/frontend/images/lincense/'.$customer->name . '/' .$customer->lincense_right) }}" class="btn btn-primary btn-sm" download>Right Download</a>
                                    <a href="{{ asset('/frontend/images/lincense/'.$customer->name . '/' . $customer->lincense_left) }}" class="btn btn-danger btn-sm" download>Left Download</a>
                                </td>
                                <td colspan="2">
                                    <a href="{{ asset('/frontend/images/passport/'.$customer->name . '/' .$customer->passport_right) }}" class="btn btn-primary btn-sm" download>Right Download</a>
                                    <a href="{{ asset('/frontend/images/passport/'.$customer->name . '/' . $customer->passport_left) }}" class="btn btn-danger btn-sm" download>Left Download</a>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">Policy Number</td>
                            </tr>
                            <tr>
                                <td style="text-align: center;" colspan="4">
                                    <img width="200px" style="border-radius: 7px;height:200px" src="/frontend/images/policy_no/{{($customer->name . '/' . $customer->policy_no) }}">
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">
                                    <a href="{{ asset('/frontend/images/policy_no/'. $customer->name . '/' .$customer->policy_no) }}" class="btn btn-danger btn-sm" target="_blank">View</a>
                                    <a href="{{ asset('/frontend/images/policy_no/'. $customer->name . '/' .$customer->policy_no) }}" class="btn btn-primary btn-sm" download>Download</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection