@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('buy_methods.index')}}">Method List</a></li>
<li class="breadcrumb-item active">Add Buy Method Item</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="panel-title">Create new Buy Method Item</span>
            </div>
            <div class="card-body">
                <div class="params-panel">
                    <form class="form-group" enctype="multipart/form-data" method="post" action="{{ route('buy_methods.store') }}">
                        @csrf

                        <div class="row g-3">
                            <div class="form-group col-md-8">
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <label class="form-label">Title <span class="text-danger">*</span> </label>
                                        <input class="form-control" type="text" name="title" value="{{ old('title') }}" required>
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label">Summary <span class="text-danger">*</span> </label>
                                        <textarea name="summary" class="form-control" rows="8" cols="80">{{ old('summary') }}</textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <label class="form-label">Status <span class="text-danger">*</span> </label>
                                        <select class="form-select select2" name="status" required>
                                            <option value="">Select One</option>
                                            <option {{ (old('status') == "1") ? 'selected' : '' }} value="1">
                                                Active
                                            </option>
                                            <option {{ (old('status') == "0") ? 'selected' : '' }} value="0">
                                                Disable
                                            </option>
                                        </select>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="form-label">Featured Image </label>
                                            <input class="form-control dropify" type="file" name="image" />
                                        </div>
                                    </div>
                                </div>
                            </div>



                            <div class="col-md-12 mt-15">
                                {{-- <a href="{{ route('categories.create') }}" class="btn btn-warning add_category">Add categories</a> --}}
                                <button type="submit" class="btn btn-primary add_shop">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection