@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('banners.index')}}">Main Banner</a></li>
<li class="breadcrumb-item"><a href="{{route('navsliders.index')}}">Nav Slider</a></li>
<li class="breadcrumb-item active">View Slider</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Nav Slider Details
                </span>
                <a href="{{ route('navsliders.create') }}" class="btn btn-secondary btn-sm">Add Nav Slider</a>
            </div>
            <div class="card-body row">
                <div class="col-md-6 ">
                    <div class="box box-primary">
                        <div class="box-header">
                            Image
                        </div>
                        <div class="box-body">
                            <img class="img-responsive product_image" src="{{ $navslider->getMedia('navslider_images')->first()->getUrl() }}" width="100%" height="auto">
                        </div>
                    </div>
                </div>

                <ul class="list-group col-md-6">
                    <li class="list-group-item">
                        <strong>Title</strong> : {{ $navslider->title }}
                    </li>

                    <li class="list-group-item">
                        <strong>Display on slider</strong> :
                        @if($navslider->status==1)
                            Yes
                            @else
                            No
                            @endif
                    </li>
                    <li class="list-group-item">
                        <strong>Place</strong> : {{ $navslider->place }}
                    </li>

                    <li class="list-group-item">
                        <strong>Created</strong> : {{ $navslider->created_at->diffForHumans() }}
                    </li>
                    <li class="list-group-item">
                        <strong>Related Category</strong> : {{ $navslider->category->name }}
                    </li>
                </ul>

                <a href="{{route('navsliders.edit', $navslider)}}" class="btn btn-primary mt-3"> Edit This Navslider
                </a>

            </div>
        </div>
    </div>


</div>
@endsection