@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('offer_requests.index')}}">Offer Request List</a></li>
<li class="breadcrumb-item active">Show Customer Details</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span>
                    Customer Details
                </span>
            </div>
            <div class="card-body row">
                <div class="col-md-6">
                    <div class="card panel box box-primary">
                        <div class="card-header">
                            Personal Information
                        </div>
                        <div class="card-body">
                            <ul class="list-group">
                                <li class="list-group-item">
                                    <strong>User Type</strong>: {{ $offerRequest->type }}
                                </li>
                                <li class="list-group-item">
                                    <strong>Full Name</strong>: {{ $offerRequest->name }}
                                </li>
                                @if ($offerRequest->company_name)
                                <li class="list-group-item">
                                    <strong>Company Name</strong>: {{ $offerRequest->company_name }}
                                </li>
                                @endif
                                <li class="list-group-item">
                                    <strong>Phone Number</strong>: {{ $offerRequest->phone_number }}
                                </li>
                                <li class="list-group-item">
                                    <strong>Email</strong>: {{ $offerRequest->email }}
                                </li>
                                <li class="list-group-item">
                                    <strong>Address</strong>: {{ $offerRequest->address }}
                                </li>
                                @if ($offerRequest->remarks)
                                <li class="list-group-item">
                                    <strong>Description</strong>: {{ $offerRequest->remarks }}
                                </li>
                                @endif
                                <li class="list-group-item">
                                    <strong>Created</strong> : {{ $offerRequest->created_at->format('d M, Y') }}
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                @php

                $products = [];

                if ($offerRequest->offer->type == 'product') {
                $products = $offerRequest->offer->products;
                }

                if ($offerRequest->offer->type == 'category') {
                if ($offerRequest->offer->category) {
                $products = $offerRequest->offer->category->products;
                } else {
                $products = [];
                }

                }
                @endphp

                <ul class="list-group col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">
                                Product List
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-hover table-bordered">
                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        @if ($offerRequest->offer->type == 'product')
                                        <th>Action</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($products)

                                    @foreach ($products as $key => $item)
                                    <tr>
                                        <td>
                                            <div class="d-flex">
                                                <img src="/frontend/images/products/{{ $offerRequest->offer->type == 'product' ? $item->product->image : $item->image }}" class="product__image" alt="">
                                                <div class="ps-3">
                                                    <div class="">
                                                        {{ $offerRequest->offer->type == 'product' ? $item->product->title : $item->title }}
                                                    </div>
                                                    <div class="text-muted">
                                                        {{ $offerRequest->offer->type == 'product' ? $item->product->category->title : $item->category->title }}
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        @if ($offerRequest->offer->type == 'product')
                                        <td class="text-center">
                                            <a type="button" class="text-danger fs-4" data-bs-toggle="modal" data-bs-target="#deleteModal{{$item->id}}">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19.4 22.169" fill="currentColor" width="16">
                                                    <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.4">
                                                        <path data-name="Rectangle 2" d="M8.238.7h2.923a2 2 0 012 2v.769h0-6.923 0V2.7a2 2 0 012-2z"></path>
                                                        <path data-name="Line 1" d="M.7 3.469h18"></path>
                                                        <path data-name="Path 77" d="M14.649 21.469h-9.9a1.385 1.385 0 01-1.38-1.279L2.085 3.469h15.231L16.029 20.19a1.385 1.385 0 01-1.38 1.279z"></path>
                                                        <path data-name="Line 2" d="M7.623 6.238V18.7"></path>
                                                        <path data-name="Line 3" d="M11.777 6.238V18.7"></path>
                                                    </g>
                                                </svg>
                                            </a>
                                            <div id="deleteModal{{$item->id}}" class="delete-modal modal fade" role="dialog">
                                                <!-- Delete Modal -->
                                                <div class="modal-dialog modal-sm">
                                                    <div class="modal-content">
                                                        <div class="modal-body text-center">
                                                            <h4 class="modal-heading">Are You Sure ?</h4>
                                                            <p>Do you really want to delete these records? This process cannot be undone.</p>
                                                        </div>
                                                        <div class="modal-footer">
                                                            {!! Form::open(['method' => 'DELETE', 'route' => ['offer_products.destroy', $item]]) !!}
                                                            {!! Form::reset("No", ['class' => 'btn btn-gray', 'data-bs-dismiss' => 'modal']) !!}
                                                            {!! Form::submit("Yes", ['class' => 'btn btn-danger']) !!}
                                                            {!! Form::close() !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        @endif
                                    </tr>
                                    @endforeach

                                    @else

                                    <tr>
                                        <td colspan="2" class="text-center">No product found</td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </ul>
            </div>
        </div>
    </div>


</div>
@endsection