@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('plugins.index') }}">Plugin List</a></li>
<li class="breadcrumb-item active">New Plugin</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default" data-collapsed="0">
            <div class="card-header">
                <div class="card-title">
                    Create New Plugin
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('plugins.store') }}" autocomplete="off" enctype="multipart/form-data" method="post" accept-charset="utf-8">
                    {{csrf_field()}}
                    <div class="row g-3">
                        <div class="form-group col-md-4 {{ $errors->has('title') ? ' has-error' : '' }}">
                            <label class="form-label">Title <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control" name="title" value="{{ old('title') }}" required>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Type <span class="text-danger">*</span></label>
                            <select class="form-select select2" name="type" required>
                                <option value="">Select One</option>
                                <option {{ (old('type') == 'Header') ? 'selected' : '' }} value="Header">
                                    Header Section
                                </option>
                                <option {{ (old('type') == 'Body') ? 'selected' : '' }} value="Body">
                                    Body Section
                                </option>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-select select2" name="status" required>
                                <option value="">Select One</option>
                                <option {{ (old('status') == '1') ? 'selected' : '' }} value="1">Active</option>
                                <option {{ (old('status') == '0') ? 'selected' : '' }} value="0">Disable</option>
                            </select>
                        </div>

                        <div class="form-group {{ $errors->has('code') ? ' has-error' : '' }}">
                            <label class="form-label">Code <span class="text-danger">*</span> </label>
                            <textarea type="text" class="form-control" name="code" cols="50" rows="10" required>{{ old('code') }}</textarea>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-info">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection