@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"> <a href="{{ route('plugins.index') }}">Plugin List</a> </li>
<li class="breadcrumb-item active">View Plugin</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Plugin Details
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <strong class="pe-3">Title : </strong> {{ $plugin->title }}
                            </li>
                            <li class="list-group-item">
                                <strong class="pe-3">Type : </strong> {{ $plugin->type }}
                            </li>
                            <li class="list-group-item">
                                <strong class="pe-3">Status : </strong>
                                @if ($plugin->status == 1)
                                <label class="text-success p-2">Active</label>
                                @else
                                <label class="text-warning p-2">Disable</label>
                                @endif
                            </li>
                            <li class="list-group-item">
                                <strong class="pe-3">Created By:</strong>
                                {{ $plugin->user->name }}
                            </li>
                            <li class="list-group-item">
                                <strong class="pe-3">Created At:</strong>
                                {{ $plugin->created_at->format('d M, Y') }}
                            </li>
                        </ul>
                    </div>

                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Code
                                </div>
                            </div>
                            <div class="card-body">
                                {{ $plugin->code }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection