@extends('layouts.backend.main')

@section('content')
<style media="screen">
	.social-link {
		text-align: center;
		list-style: none;
		overflow: hidden;
		font-size: 24px;
		padding: 0px;
		margin: 0px;
	}

	.social-link a {
		color: black;
	}

	.social-link a:hover {
		color: #3c8dbc;
	}

	.social-link li {
		display: inline;
		margin: 5px;
	}

	.table>tbody>tr {
		position: relative;
	}
</style>
<div class="row">
	<div class="col-md-8">
		<div class="card card-default">
			<div class="card-header">
				<div class="card-title">
					Profile
				</div>
				<a href="{{ route('profile.edit') }}" class="btn btn-secondary btn-sm">Edit Profile</a>
			</div>
			<div class="card-body">
				<table class="table table-bordered" width="100%">
					<tbody style="text-align: center;">
						<tr class="text-center">
							@if ($profile->photo)
							<td colspan="2"><img src="{{ asset('/frontend/images/'.$profile->photo) }}" style="width: 100px; height: 100px;border-radius: 5px"></td>
							@else
							<td colspan="2"><img src="{{ asset('/frontend/images/logo.png') }}" style="width: 220px; height: 100px;border-radius: 5px"></td>
							@endif
						</tr>
						<tr class="text-center">
							<td>Name</td>
							<td>{{ $profile->name }}</td>
						</tr>
						<tr class="text-center">
							<td>User Type</td>
							<td>
								@if(!empty($profile->getRoleNames()))
									@foreach($profile->getRoleNames() as $v)
										<label class="bg-success text-white px-2 rounded text-capitalize">{{ $v }}</label>
										@endforeach
										@endif
							</td>
						</tr>
						<tr class="text-center">
							<td>Email</td>
							<td>{{ $profile->email }}</td>
						</tr>
						<tr class="text-center">
							<td>Phone</td>
							<td>{{ $profile->phone }}</td>
						</tr>
						<tr class="text-center">
							<td>Address</td>
							<td>{{ $profile->address }}</td>
						</tr>

					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
@endsection