@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('roles.index')}}">Role List</a></li>
<li class="breadcrumb-item active">Add Role</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Add a Role</span>
            </div>
            <div class="card-body">
                <form class="form-horizontal" method="post" action="{{route('roles.store')}}">
                    @csrf

                    <div class="form-group row">
                        <label class="col-md-4 control-label">Role Name:</label>
                        <div class="col-md-6">
                            <input class="form-control" type="text" name="name" placeholder="role name" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-12 control-label"> Select Permissions</label>
                        <div class="col-md-12 row">
                            @foreach($permissions as $permission)
                            <div class="col-md-3">
                                <input type="checkbox" id="permission" name="permissions[]" value="{{$permission->id}}"> <label class="control-label">{{$permission->name}}</label>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="col-md-offset-4">
                        <button class="btn btn-primary mt-3">Add Role</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
@endsection