@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('services.index') }}">Services List</a></li>
    <li class="breadcrumb-item active">Show Serives</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <div class="card card-default">
                <div class="card-header">
                    <span class="card-title">
                        Service Details
                    </span>
                    @can('service-create')
                        <a href="{{ route('services.create') }}" class="btn btn-secondary">Add A
                            Service</a>
                    @endcan
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6  ">
                            <div class="card card-primary product_details">
                                <div class="card-header">
                                    Image
                                </div>
                                <div class="card-body">
                                    <img class="img-responsive product_image" src="{{ $service->imageUrl }}" width="100%">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">

                            <ul class="list-group ">
                                <li class="list-group-item">
                                    <strong>Title</strong> : {{ $service->title }}
                                </li>

                                <li class="list-group-item">
                                    <strong>Summary</strong> : {{ $service->summary }}
                                </li>

                                <li class="list-group-item">
                                    <strong>Created</strong> :
                                    {{ $service->created_at ? $service->created_at->diffForHumans() : '' }}
                                </li>
                                <li class="list-group-item">
                                    <strong>Created by</strong> : {{ $service->user ? $service->user->name : '' }}
                                </li>
                            </ul>
                            @can('service-edit')
                                <a href="{{ route('services.edit', $service) }}" class="btn btn-primary mt-3"> Edit This Service
                                </a>
                            @endcan
                        </div>
                    </div>

                </div>
            </div>
        </div>


    </div>
@endsection
