@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('social_medias.index') }}">Social Media List</a></li>
    <li class="breadcrumb-item active">Show Social Media</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <div class="card card-default">
                <div class="card-header">
                    <span class="card-title">
                        Social Media Details
                    </span>
                    @can('social-media-create')
                        <a href="{{ route('social_medias.create') }}" class="btn btn-secondary">Add Social Media</a>
                    @endcan
                </div>
                <div class="card-body row">
                    <ul class="list-group col-md-6">
                        <li class="list-group-item">
                            <strong>Content</strong> : {{ $socialMedia->message }}
                        </li>
                        <li class="list-group-item">
                            <strong>Link </strong> : {{ $socialMedia->link }}
                        </li>
                        <li class="list-group-item">
                            <strong>Link </strong> : {{ $socialMedia->like }}
                        </li>
                        <li class="list-group-item">
                            <strong>Link </strong> : {{ $socialMedia->link }}
                        </li>
                        <li class="list-group-item">
                            <strong>Date</strong> : {{ $socialMedia->date ? $socialMedia->date->format('d M, Y') : '' }}
                        </li>
                        <li class="list-group-item">
                            <strong>Created</strong> :
                            {{ $socialMedia->created_at ? $socialMedia->created_at->format('d M, Y') : '' }}
                        </li>
                        <li class="list-group-item">
                            <strong>Created by</strong> : {{ $socialMedia->user->name }}
                        </li>
                    </ul>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Image
                                </div>
                            </div>
                            <div class="card-body">
                                <img src="{{ $socialMedia->imageUrl }}" class="w-100" alt="">
                            </div>
                        </div>
                    </div>
                    @can('social-media-edit')
                        <a href="{{ route('social_medias.edit', $socialMedia) }}" class="btn btn-primary mt-3">
                            Edit
                        </a>
                    @endcan
                </div>
            </div>
        </div>
    </div>
@endsection
