@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('teams.index')}}">Team List</a></li>
<li class="breadcrumb-item active">Edit Team Member</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Create Team Member</span>
            </div>
            <div class="card-body">
                <div class="params-panel">
                    <form class="form-group" method="post" enctype="multipart/form-data" action="{{route('teams.update', $team)}}">
                        @csrf
                        @method('put')
                        <div class="row">
                            <div class="col-md-8 row g-3">
                                <div class="form-group">
                                    <label class="control-label">Full Name:</label>
                                    <input class="form-control" type="text" name="full_name" value="{{ old('full_name', $team->full_name) }}" required>
                                </div>
                                <div class="form-group">
                                    <label class="control-label">Company:</label>
                                    <input class="form-control" type="text" name="company_name" value="{{ old('company_name', $team->company_name) }}" required>
                                </div>
                                <div class="form-group">
                                    <label class="control-label">Position:</label>
                                    <input class="form-control" type="text" name="position" value="{{ old('position', $team->position) }}" required>
                                </div>

                                <div class="form-group">
                                    <label class="control-label">Message:</label>
                                    <textarea class="form-control" type="text" name="description" placeholder="Message" required>{{ old('description', $team->description) }}</textarea>
                                </div>
                            </div>
                            <div class="col-md-4 row g-3">
                                <div class="form-group">
                                    <label class="control-label">Feature Image</label>
                                    <input type="file" class="form-control dropify" data-default-file="/frontend/images/teams/{{ $team->image }}" name="image">
                                </div>
                                <div class="form-group">
                                    <button class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection