@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('users.index')}}">User List</a></li>
<li class="breadcrumb-item active">Add User</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Add User</span>
            </div>
            <div class="card-body">
                <div class="params-panel">
                    <form class="form-group" method="post" action="{{route('users.store')}}" enctype="multipart/form-data">
                        {{csrf_field()}}

                        <div class="row g-3">
                            <div class="form-group col-6">
                                <label class="form-label">User Name <span class="text-danger">*</span> </label>
                                <input class="form-control" type="text" name="name" value="{{ old('name') }}" required>
                            </div>

                            <div class="form-group col-6">
                                <label class="form-label">Address <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="address" value="{{ old('address') }}" required>
                            </div>

                            <div class="form-group col-6">
                                <label class="form-label">Phone No.: <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="phone" value="{{ old('phone') }}" required>
                            </div>

                            <div class="form-group col-6">
                                <label class="form-label">User Email <span class="text-danger">*</span></label>
                                <input class="form-control" type="email" name="email" value="{{ old('email') }}" required>
                            </div>

                            <div class="form-group col-6">
                                <label class="form-label">Password <span class="text-danger">*</span></label>
                                <input class="form-control" type="Password" name="password" required>
                            </div>

                            <div class="form-group col-6">
                                <label class="form-label">Confirm Password <span class="text-danger">*</span></label>
                                <input class="form-control" type="Password" name="password_confirmation" confirmed>
                            </div>

                            <div class="form-group col-6">
                                <label class="form-label">Choose a Role <span class="text-danger">*</span></label>
                                <select name="role" class="form-control select2 text-capitalize" required>
                                    <option value="">Select One</option>
                                    @foreach($roles as $role)
                                    <option class="text-capitalize" {{ old('role') == $role->name ? 'selected' : '' }} value="{{$role->name}}">{{$role->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-0">
                                <button class="btn btn-primary">Add User</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection