@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('videos.index') }}">Video List</a></li>
    <li class="breadcrumb-item active">Edit Video</li>
@endsection

@section('content')
    <form class="form-group" method="post" action="{{ route('videos.update', $video) }}" enctype="multipart/form-data">
        {{ csrf_field() }}
        @method('put')
        <div class="row g-4">
            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-header">
                        <span class="card-title">Edit Video</span>
                    </div>
                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="row g-3">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label class="form-label">Video Title <span class="text-danger">*</span>
                                            </label>
                                            <input class="form-control" type="text" id="title" name="title"
                                                value="{{ old('title', $video->title) }}" required>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">Link <span class="text-danger">*</span></label>
                                            <input class="form-control" type="text" name="link"
                                                value="{{ old('link', $video->link) }}" required>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">Status <span class="text-danger">*</span> </label>
                                            <select name="status" class="form-control select2">
                                                <option value="">Select One</option>
                                                <option {{ old('status', $video->status) == '1' ? 'selected' : '' }}
                                                    value="1">Active
                                                </option>
                                                <option {{ old('status', $video->status) == '0' ? 'selected' : '' }}
                                                    value="0">Disable
                                                </option>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="accordion" id="imageManage">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Manage Image
                        </button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#imageManage">
                        <div class="accordion-body">
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label class="form-label">Featured Image </label>

                                    <input type="file" class="form-control dropify" name="image">
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-4">

                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </form>
@endsection
