@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Hello !</h1>
<p>
    We want to inform you that a new inquiry has been received from a user. Here are the details:
</p>
<p>
<ul>
    <li style="font-size: 16px;list-style: none"> <strong>Personal Details</strong> </span> </li>
    <li style="font-size: 16px;">Full Name : <span style="padding-left: 20px;">{{ $name }}</span> </li>
    <li style="font-size: 16px;">Email : <span style="padding-left: 20px;text-transform: lowercase;">{{ $email }}</span> </li>
    <li style="font-size: 16px;">Phone : <span style="padding-left: 20px;">{{ $phone }}</span> </li>
    <li style="font-size: 16px;">Address : <span style="padding-left: 20px;">{{ $address }}</span> </li>
    <li style="font-size: 16px;">Question : <span style="padding-left: 20px;">{{ $question }}</span> </li>
</ul>

</p>

@isset($warrentyCard)
@component('mail::button', ['url' => $warrentyCard, 'color' => 'primary'])
Download Warranty Card
@endcomponent
@endisset

@isset($billingCard)
@component('mail::button', ['url' => $billingCard, 'color' => 'primary'])
Download Billing Card
@endcomponent
@endisset

<p>
    Please review the application and proceed with the necessary steps. Your timely attention to this matter is appreciated.
</p>


{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent
