@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Hello !</h1>
<p>
    We're writing to notify you that a new dealer application has been received through our website. Here are the application details:
</p>
<p>
<ul>
    <li style="font-size: 16px;list-style: none"> <strong>Personal Details</strong> </span> </li>
    <li style="font-size: 16px;">Full Name : <span style="padding-left: 20px;">{{ $name }}</span> </li>
    <li style="font-size: 16px;">Email : <span style="padding-left: 20px;text-transform: lowercase;">{{ $email }}</span> </li>
    <li style="font-size: 16px;">Phone : <span style="padding-left: 20px;">{{ $phone }}</span> </li>
    <li style="font-size: 16px;">Address : <span style="padding-left: 20px;">{{ $address }}</span> </li>
</ul>

</p>

<p>
<ul>
    <li style="font-size: 16px;list-style: none"> <strong>Company Details</strong> </span> </li>
    <li style="font-size: 16px;">Company Name : <span style="padding-left: 20px;">{{ $companyName }}</span> </li>
    <li style="font-size: 16px;">PAN No.: : <span style="padding-left: 20px;text-transform: lowercase;">{{ $panNo }}</span> </li>
    <li style="font-size: 16px;">Remarks : <span style="padding-left: 20px;">{{ $remarks }}</span> </li>
</ul>

</p>

@isset($warrentyCard)
@component('mail::button', ['url' => $warrentyCard, 'color' => 'primary'])
Download Warrenty Card
@endcomponent
@endisset

@isset($billingCard)
@component('mail::button', ['url' => $billingCard, 'color' => 'primary'])
Download Billing Card
@endcomponent
@endisset

<p>
    Please review the application and proceed with the necessary steps. Your timely attention to this matter is appreciated.
</p>


{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent